<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function configfile_check()
{
    global $CFG, $fsCFG, $version, $release;

    print_section_header('設定ファイル(config.php/fsconfig.phpのチェック');

    echo '<p>　fs_moodle4からはfs_moodle固有の設定を保存する設定ファイルfsconfig.phpをmoodleフォルダではなく，moodledata/config（初期設定）にも保存可能としました．';
    echo 'これはセキュリティ上の問題に加え，管理者がWebフォーム上からfsconfig.phpを変更可能とするためです．';
    echo 'Moodle標準の設定ファイルは今まで通り，moodleフォルダに格納して下さい．</p>';
    print_notice_message('警告', 'fs_moodle4よりfsconfig.phpは自動生成可能となりました．その結果，$fsCFGに設定していたいくつかの設定はfsconfig_option.phpに設定する方針となりました．バナーの追加やMIMEタイプの追加，バックアップ制限条件などです．上書きをしてしまうとこれらの設定が消えてしまいますので，fs_moodle4以前のバージョンからアップグレードした場合は，必ずfsconfig.phpのバックアップを作成した上で設定を行って下さい．');

    print_subsection_header('fsconfig.php / fsconfig_option.phpの存在のチェック');
    echo '　現在のfs_moodle設定ファイル格納用のフォルダは'.color_blue(FSCONFIGDIR).'です．';
    newline();
    echo '　このフォルダは';
    if (fs_file_exists(FSCONFIGDIR)) echo '既に作成済みです．';
      else                           echo color_red('未作成').'です．';
    print_notice_message('コメント', '標準の場所から変更したい場合は，'.color_blue($CFG->dirroot.'/lib/fs_moodle/fs_index.php').'冒頭の'.color_blue('FSCONFIGDIR').'のdefine()を変更して下さい．');
    if (fs_is_dir(FSCONFIGDIR)) {
        newline();
        echo '<table border="1" width="95%" align="center" cellpadding="5" cellspacing="0" style="bordercolor: #333333">';
        echo '<caption align="top">'.FSCONFIGDIR.'フォルダ内のファイル一覧</caption>';
        echo '<tr bgcolor="#cccccc">';
        echo '<th>No.</th><th>ファイル名</th><th>ファイルサイズ</th><th>タイムスタンプ</th></tr>';
        $no = 1;
        if ($dirlist = fs_opendir(FSCONFIGDIR)) {
            while (($ent = readdir($dirlist)) !== FALSE) {
                if (($ent == '.') || ($ent == '..')) continue;
                echo '<tr>';
                echo '<td align="center">'.$no.'</td>';
                echo '<td>';
                if (strcasecmp($ent, 'fsconfig.php') == 0) echo color_blue($ent);
                  else if (strcasecmp($ent, 'fsconfig_option.php') == 0) echo color_blue($ent);
                  else echo $ent;
                echo '</td>';
                echo '<td align="right">'.fs_filesize(FSCONFIGDIR.'/'.$ent).'&nbsp;byte </td>';
                echo '<td align="center">'.date('Y/m/d H:i:s', fs_filemtime(FSCONFIGDIR.'/'.$ent)).'</td>';
                echo '</tr>';
                $no++;
            }
            closedir($dirlist);
        }
        echo '</table>';
    }
    newline();
    echo '　このフォルダに'.color_blue('fsconfig.php').'は';
    if (fs_file_exists(FSCONFIGDIR.'/fsconfig.php')) {
        echo color_blue('存在します').'．';
        newline();
        if (fs_file_exists($CFG->dirroot.'/fsconfig.php')) {
            echo 'fsconfig.phpがmoodleフォルダ（'.$CFG->dirroot.'）にも存在します．';
            echo 'この場合，'.color_blue(FSCONFIGDIR).'のfsconfig.phpが優先されます．';
        }
    } else {
        echo color_blue('存在しません').'．';
        newline();
        if (fs_file_exists($CFG->dirroot.'/fsconfig.php')) {
            echo 'fsconfig.phpがmoodleフォルダ（'.$CFG->dirroot.'）に存在します．';
            echo '何らかの理由により'.color_blue(FSCONFIGDIR).'を使用しなくても問題はありません．';
        } else {
            echo color_red('fsconfig.phpがmoodleフォルダ（'.$CFG->dirroot.'）にも存在しません！');
            echo 'これは非常に悪い状態です．[fsconfig.php編集の開始]をクリックし，[上書き]でfsconfig.phpを作成して下さい．';
            echo '[上書き]で作成したfsconfig.phpはデフォルト値です．ご自分のサイトに合わせてWeb上で変更して更新（[上書き]）して下さい．';
            newline();
            echo '　このエラーが表示されることは基本的にあり得ません．';
            echo '管理者がこのサイトにログインするとデフォルト値のfsconfig.phpが自動生成されるためです．';
        }
    }
    echo '　このフォルダに'.color_blue('fsconfig_option.php').'は';
    if (fs_file_exists(FSCONFIGDIR.'/fsconfig_option.php')) {
        echo color_blue('存在します').'．';

        echo '<br /><br /><div class="navbutton"><div class="singlebutton">';
        echo '<form action="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/fsconfig_output.php" method="post" target="_blank">';
        echo '<input type="hidden" name="action" value="displayopt" />';
        echo '<input type="submit" value="fsconfig_option.phpを表示" title="現在有効なfsconfig_option.phpを別ウィンドウに表示します．"/>';
        echo '</form>';
        echo '&nbsp;&nbsp;';
        echo '<form action="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/fsconfig_output.php" method="post" >';
        echo '<input type="hidden" name="action" value="downloadopt" />';
        echo '<input type="submit" value="fsconfig_option.phpをダウンロード" title="現在有効なfsconfig_option.phpをダウンロードします．"/>';
        echo '</form>';
        echo '</div></div>';
    } else {
        echo color_blue('存在しません').'．';
        echo color_blue('fsconfig_option.php').'は必須のファイルではありませんが，';
        echo 'fs_moodle4以前のバージョンからご利用のサイトではMIMEタイプの追加やフッターの追加などを行っていたかも知れません．';
        echo 'それらの'.color_blue('関数形式で宣言するタイプ').'の設定は自動生成するのが困難なため，';
        echo 'fs_moodle4以降のfsconfig.phpの自動生成機能では対応できません．';
        echo 'もしfsconfig.phpに記述していた場合は手作業でfsconfig_option.phpに記述して下さい．';
        print_notice_message('注意', 'fsconfig_option.phpの雛形は自動作成しません．存在しないのであればご自分で作成お願いします．config.phpやfsconfig.phpと同様に，文字コードはUTF-8，BOMなし，ファイルの頭とお尻は余計な改行を入れず，'.htmlspecialchars('<?php').'で始め，'.htmlspecialchars('?>').'で終えるようにして下さい．');
    }
    print_subsection_footer();

    print_subsection_header('config.phpの$CFG->unicodecleanfilenameのチェック');
    echo '　config.phpには必ず';
    echo color_blue('$CFG->unicodecleanfilename = true;');
    echo 'の設定を記述して下さい．';
    echo 'この設定を行わないと，例えfs_moodleでも日本語のファイル名／フォルダ名を使用できません．';
    echo 'もし設定していないと，日本語文字は全て「_」（半角アンダーバー）に変換されてしまいます．';
    newline();
    echo '　あなたのサーバのconfig.phpには，';
    if (empty($CFG->unicodecleanfilename)) {
        echo color_red('<B>$CFG->unicodecleanfilenameが設定されていません！！！</B>');
        echo 'このままでは日本語のファイル名／フォルダ名を一切，扱うことができませんので，';
        echo 'config.phpに'.color_blue('$CFG->unicodecleanfilename = true;').'を';
        echo color_red('今すぐに追加して下さい．');
    } else {
        echo color_blue('$CFG->unicodecleanfilenameが設定されています．').'ご安心下さい．';
    }
    if (empty($CFG->unicodedb) || !$CFG->unicodedb) {
        newline();
        echo '　なお，あなたのサーバのconfig.phpには'.color_blue('$CFG->unicodedb');
        echo 'が'.color_red('設定されていないか，あるいは無効になっています．');
        echo '実害は報告されていませんが，';
        echo color_blue('$CFG->unicodedb = true;').'を設定することが推奨されています．';
    }
    print_subsection_footer();

    print_subsection_header('config.phpとfsconfig.phpとfsconfig_option.phpの頭とお尻のチェック');
    echo '　各ファイルの&lt;?phpの前と，?&gt;の後に余計な文字（改行，空行含む）が無いかチェックします．';
    echo '余計な文字がある場合，ダウンロードしたファイルにこれらの文字が混入する異常現象が発生します．';
    // http://moodle.org/mod/forum/discuss.php?d=106762
    newline();
    newline();
    // config.phpのチェック
    echo '　config.phpは';
    if (($status = check_config_head_and_tail($CFG->dirroot.'/config.php')) == 1) echo color_blue('正常').'です．';
        else echo color_red('異常（'.err_msg_config($status).'）').'です．';
    // fsconfig.phpのチェック
    echo 'fsconfig.phpは';
    if (($status = check_config_head_and_tail($CFG->dirroot.'/fsconfig.php', FSCONFIGDIR.'/fsconfig.php')) == 1) echo color_blue('正常').'です．';
        else echo color_red('異常（'.err_msg_config($status).'）').'です．';
    // fsconfig_option.phpのチェック
    if (fs_file_exists(FSCONFIGDIR.'/fsconfig_option.php')) {
        echo 'fsconfig_option.phpは';
        if (($status = check_config_head_and_tail($CFG->dirroot.'/fsconfig_option.php', FSCONFIGDIR.'/fsconfig_option.php')) == 1) {
            echo color_blue('正常').'です．';
        } else {
            echo color_red('異常（'.err_msg_config($status).'）').'です．';
        }
    }
    newline();
    echo '　もしBOM(Byte Order Mark)が頭にあると指摘された場合はテキストエディタを変更して下さい．';
    echo 'BOMはUnicodeの並びを判別するために一部のエディタが自動挿入する非表示な文字です．';
    echo 'Windowsのメモ帳を使うのは止めて下さい．';
    newline();
    echo '　なお，PHPのファイルは終端に「？>」が無くても異常ではありません．その場合はファイルの最後までがPHPのファイルであると判断されるだけです．';
    echo '異常なゴミが混ざるくらいならば，「？>」を省略するのも手ですね．';
    print_subsection_footer();

    print_subsection_header('moodleフォルダのBOMチェック');
    echo "　BOMのチェックをmoodleフォルダの全ソースファイルに対して行います．\n";
    echo '検査対象は拡張子が'.color_blue('php').'と'.color_blue('html')."のファイルです．\n";
    echo "この機能は，config.php/fsconfig.php/fsconfing_option.phpにBOM等の問題が無いのにも関わらず，";
    echo "ファイルのダウンロードや画像の表示が正常に行えない場合の原因究明のためのものです．\n";
    echo 'たとえば<a href="http://moodle.org/mod/forum/discuss.php?d=150290" target="_blank">こちらのページ</a>';
    echo "のような状況です．\n";
    echo "あなたがUTF-8の編集（BOMなし）に対応しないテキストエディタを用いて";
    echo "Moodleのソースファイルを編集してしまった場合を想定しています．\n";
    print_notice_message('警告', 'この処理には長時間を要します．PHPやApacheの設定によっては処理の途中でタイムアウトしてしまう場合もあります．詳しくは各ドキュメントを読んで下さい．');
    echo '<form nethod="post" action="bomchecker.php" target="_blank">';
    echo '<input type="radio"  name="detail" value="0" checked="checked" />簡易表示（BOMを含むファイルのみ表示）<br />';
    echo '<input type="radio"  name="detail" value="1" />詳細表示<br />';
    echo '<input type="submit" neme="Submit" value="チェック実行" />';
    echo '</form>';
    print_subsection_footer();

/* まだ試験中(2008/12/03)
    print_section_header('config.php / fs_config.phpを改竄可能かどうかをチェック');
    echo '　Moodleのソースファイルを格納しているフォルダ（たとえばmoodle）はWebサーバ経由で書き換え可能であってはいけません．Linuxの場合はオーナーをapache以外に変更する必要があります．Windowsの場合はサービスプログラムはローカルシステムアカウントで実行されます．新しくWebサーバを起動するためのアカウントを作成し，そのアカウントからは読み出しと実行はできても変更はできないようなパーミッション（セキュリティ）の設定を行う必要があります．';
    newline();
    check_config_security($CFG->dirroot.'/config.php');
    check_config_security($CFG->dirroot.'/fsconfig.php');
    print_section_footer();
*/
    print_section_footer();
}

function server_system_check()
{
    global $CFG, $fsCFG, $release;

    print_section_header('基本的なサーバ設定のチェック');
    print_subsection_header('サーバシステムのチェック');
    echo '<ul>';
    echo '<li>サーバOSの種類は'.color_blue($CFG->ostype.'('.$CFG->os.'）').'であると認識されています．</li>';
    echo '<li>fs_moodleのリリース／バージョンは'.color_blue($fsCFG->release.'／'.$fsCFG->version).'です．</li>';
    echo '<li>Moodleのリリース／バージョンは'.color_blue(fs_get_moodle_release().'／'.fs_get_moodle_version()).'です．</li>';
    echo '<li>サーバソフトウェア（Webサーバ）の種類($_SERVER['."'SERVER_SOFTWARE'".']）は';
    echo color_blue($_SERVER['SERVER_SOFTWARE']).'です．</li>';
    echo '<li>'.color_blue('$fsCFG->convUTF8serverVariable').'の設定は'.color_blue(($fsCFG->convUTF8serverVariable == true ? 'true' : 'false')).'です．';
    echo 'この設定をtrueに設定すると，$_SERVERスーパーグローバル変数をUTF-8に自動変換します．';
    if (strpos($_SERVER['SERVER_SOFTWARE'], 'IIS')) {
        if ($fsCFG->convUTF8serverVariable !== true) {
            echo '：IISは$_SERVERスーパーグローバル変数の値を勝手にシフトJISに変換してしまう仕様上の問題があります．';
            echo 'WebサーバがIISならば，日本語ファイル名のファイルのダウンロード等に不具合の生じる可能性があるので，';
            echo 'この設定をtrueに設定することをお勧めします．';
        } else {
            echo '：WebサーバがIISならば正しい設定です．';
        }
    } else {
        echo '：WebサーバがIISでないならばtrueでもfalseでも構いません．';
    }
    echo '</li>';
    echo '</ul>';
    echo '　ちなみにあなたのブラウザの種類は'.color_blue($_SERVER['HTTP_USER_AGENT']).'です．';
    print_subsection_footer();

    print_subsection_header('PHPのmbstring関係の設定の確認');
    echo '　日本語のデータを扱う場合にはmbstring関係の設定が重要です．';
    echo 'あなたのサーバのPHPの設定を見るには<a href="'.$CFG->wwwroot.'/admin/phpinfo.php" target="_blank">こちら</a>をクリックして下さい．';
    newline();
    echo '<table cellpadding="3"><tr><th>設定値名</th><th>（推奨値）</th><th>現在値</th>';
    echo '<tr><td>mbstring.language</td><td>（Japanese）</td><td>'.ini_get('mbstring.language').'</td></tr>';
    echo '<tr><td>mbstring.internal_encoding</td><td>（UTF-8）</td><td>'.ini_get('mbstring.internal_encoding').'</td></tr>';
    echo '<tr><td>mbstring.http_output</td><td>（UTF-8）</td><td>'.ini_get('mbstring.http_output').'</td></tr>';
    echo '<tr><td>mbstring.encoding_translation</td><td>（1 or On）</td><td>'.ini_get('mbstring.encoding_translation').'</td></tr>';
    echo '<tr><td>mbstring.func_overload</td><td>（0）</td><td>'.ini_get('mbstring.func_overload').'</td></tr>';
    echo '</table>';
    if (ini_get('mbstring.language') != 'Japanese') {
        echo color_red('（注意！）').'もし，mbstring.languageが設定されていない場合はneutralが自動的に設定されます．';
        echo "この状態ですとmb_convert_encoding('UTF-8', 'auto')が正常に動作しません．";
        echo '文字列エンコーディングがシフトJISの場合に検出できず，PHPがエラーを発生します．';
        echo 'Japaneseを設定することを勧めます．';
        newline();
    }
    if (ini_get('mbstring.internal_encoding') != 'UTF-8') {
        echo color_red('（注意！）').'mbstring.internal_encodingにUTF-8以外が設定されています．UTF-8に設定することを勧めます．';
        newline();
    }
    if (ini_get('mbstring.http_output') != 'UTF-8') {
        echo color_red('（注意！）').'mbstring.http_outputにUTF-8以外が設定されています．UTF-8に設定することを勧めます．';
        newline();
    }
    if (ini_get('mbstring.encoding_translation') != '1' && ini_get('mbstring.encoding_translation') != 'On') {
        echo color_red('（注意！）').'mbstring.encoding_translationにOn以外が設定されています．Onに設定することを勧めます．';
        newline();
    }
    if (ini_get('mbstring.func_overload') != '0') {
        echo color_red('（注意！）').'mbstring.func_overloadに0以外が設定されています．0に設定することを勧めます．';
        echo '特に，もし7に設定しているならば必ず0に設定して下さい．動作を保障できません．';
        newline();
    }
    print_subsection_footer();

    print_subsection_header('eAcceleratorの設定');
    echo '　eAcceleratorはPHPの動作速度を高速化するソフトウェアです．';
    echo 'moodle.orgからダウンロードしたMoodle for Windowsパッケージであれば標準で機能が有効に設定されています．';
    echo 'しかし，<a href="http://moodle.org/mod/forum/discuss.php?d=150154" target="_blank">こちら</a>';
    echo 'に報告したように，ある時期に公開されたMoodle for WindowsパッケージではPHPの初期設定（'.color_blue('server/php/php.ini').'）';
    echo 'が不適切なため，原因不明の異常現象に遭遇します．';
    newline();
    echo '　eacceleratorのセクションにおける'.color_blue('eaccelerator.check_mtime').'の値を確認して下さい．';
    echo 'もし，'.color_blue('eaccelerator.check_mtime="0"').'と設定されていたら異常です．';
    echo color_blue('"1"').'が正しい設定です．';
    newline();
    newline();
    echo '　いま，あなたのサーバは'.color_blue('eaccelerator.enable').'が';
    $check_enable = ini_get('eaccelerator.enable');
    if (empty($check_enable)) {
        echo color_blue('未設定').'なので'.color_blue('eAccelerator機能は使用されていません．');
        newline();
    } else {
        echo color_blue('有効').'なので'.color_blue('eAccelerator機能は使用されています．');
        newline();
        echo '　'.color_blue('eaccelerator.check_mtime').'は';
        $check_mtime = ini_get('eaccelerator.check_mtime');
        if (empty($check_mtime)) {
            echo color_red('"1"ではありません．危険です．速やかに"1"に変更して下さい．');
        } else {
            echo color_blue('"0"以外（'.$check_mtime.')に設定').'されています．多分，大丈夫でしょう．';
        }
        newline();
    }
    print_subsection_footer();
    print_section_footer();
}

function documents_check()
{
    global $CFG, $fsCFG;

    print_section_header('ドキュメントに関するチェック');
    print_subsection_header_fs_cfg('officialWikiURI');
    echo '<ul>';
    echo '<li>fs_moodle本家サイトのWikiドキュメントの基準URI：['.$fsCFG->officialWikiURI.']</li>';
    echo '</ul>';
    echo '　このパラメータは特別な理由が無い限りは変更する必要はありません．';
    echo '万が一，設定を行っていなくてもプログラム中でデフォルト値を設定して利用するので警告も発しません．';
    echo 'このパラメータを変更するのは，古いバージョンのfs_moodleを使用し続ける必要があり，';
    echo 'かつ本家fs_moodleサイトのURIが変更になってしまった時ぐらいでしょう．';
    print_fs_cfg_condition('officialWikiURI');
    print_subsection_footer();

    print_subsection_header_fs_cfg('localWikiURI');
    echo '<ul>';
    if (empty($fsCFG->localWikiURI)) {
        echo '<li>現在，ローカルなHTML形式ドキュメントの基準URIは指定されていません．</li>';
    } else {
        echo '<li>現在，ローカルなHTML形式ドキュメントの基準URIは['.$fsCFG->localWikiURI.']です．</li>';
    }
    echo '</ul>';
    echo '　このパラメータも特別な事情がある時以外は指定する必要がありません．';
    echo color_blue('$fsCFG->officialWikiURI').'がMoodleのWikiへのアクセスであるのに対して，';
    echo 'このパラメータで指定するURI（パラメータ名にWikiを含むにも関わらず）は単純な静的Webページであるという違いに気を付けて下さい．';
    newline();
    echo '　このパラメータが意味を持つのは，例えばMoodleをインターネットから隔絶された環境で運用・管理する場合と，';
    echo 'fs_moodleに関する情報を独自のコンテンツでドキュメントを管理している場合です．';
    echo 'fs_moodle本家サイトではfs_moodleに関する全情報をまとめたWikiを約半年くらいの周期でHTML形式に変換して公開しています．';
    echo 'その静的なHTMLファイルをローカルなWebサーバに展開して閲覧することを可能にする設定です．';
    echo color_blue('officialWikiURI').'と'.color_blue('localWikiURI');
    echo 'は共にfs_moodle独自の機能・設定に関する情報へのリンク生成にのみ関わる設定であり，一般利用者には';
    echo '何ら影響の無い設定です．';
    print_notice_message('注意', 'ローカルHDD上に展開したWebページ（例えばWindowsのデスクトップ上）へのWebサーバを介さないリンクは（私の環境では）正常に動作しませんでした．なんらかのセキュリティ上の問題かも知れません．ＩＥ等のWebブラウザにダイレクトにアドレスを渡せば閲覧可能ですが，Moodleへアクセスしている状態からMoodle上のリンクによりローカルHDD上のコンテンツへのジャンプは制限されている，という印象です．情報をお持ちの方は御連絡下さい．');

    print_fs_cfg_condition('localWikiURI');
    print_subsection_footer();
    print_section_footer();
}

if ($page == 'fsc_server') {
// ファイルチェック
    if (filecheck_fs_moodle() === 2) {
        echo '致命的な問題です．処理を中断します．<br/>';
        die;
    }
}

// 設定ファイルのチェック
configfile_check();

// サーバのチェック
server_system_check();

// Wikiなどのドキュメント参照関係のチェック
documents_check();


?>