/**
 * Password Unmask functionality.
 *
 * @module     core_form/passwordunmask
 * @package    core_form
 * @class      passwordunmask
 * @copyright  2016 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.2
 */
define("core_form/passwordunmask",["jquery","core/templates"],(function($,Template){var PasswordUnmask=function(elementid){this.wrapperSelector='[data-passwordunmask="wrapper"][data-passwordunmaskid="'+elementid+'"]',this.wrapper=$(this.wrapperSelector),this.editorSpace=this.wrapper.find('[data-passwordunmask="editor"]'),this.editLink=this.wrapper.find('a[data-passwordunmask="edit"]'),this.editInstructions=this.wrapper.find('[data-passwordunmask="instructions"]'),this.displayValue=this.wrapper.find('[data-passwordunmask="displayvalue"]'),this.inputFieldLabel=$('label[for="'+elementid+'"]'),this.inputField=this.editorSpace.find(document.getElementById(elementid)),this.inputField.attr("type","hidden"),this.inputField.removeClass("hiddenifjs"),this.editInstructions.attr("id")||this.editInstructions.attr("id",elementid+"_instructions"),this.editInstructions.hide(),this.setDisplayValue(),this.addListeners()};return PasswordUnmask.prototype.addListeners=function(){return this.wrapper.on("click keypress",'[data-passwordunmask="edit"]',$.proxy((function(e){"keypress"===e.type&&13!==e.keyCode||(e.stopImmediatePropagation(),e.preventDefault(),"hidden"!==this.inputField.attr("type")?"click"===e.type||$(e.relatedTarget).is(":input")?this.turnEditingOff(!1):this.turnEditingOff(!0):this.turnEditingOn())}),this)),this.wrapper.on("click keypress",'[data-passwordunmask="unmask"]',$.proxy((function(e){"keypress"===e.type&&13!==e.keyCode||(e.stopImmediatePropagation(),e.preventDefault(),this.wrapper.data("unmasked",!this.wrapper.data("unmasked")),this.setDisplayValue())}),this)),this.wrapper.on("keydown","input",$.proxy((function(e){"keydown"===e.type&&13!==e.keyCode||(e.stopImmediatePropagation(),e.preventDefault(),this.turnEditingOff(!0))}),this)),this.inputFieldLabel.on("click",$.proxy((function(e){e.preventDefault(),this.turnEditingOn()}),this)),this},PasswordUnmask.prototype.checkFocusOut=function(e){this.isEditing()&&window.setTimeout($.proxy((function(){var relatedTarget=e.relatedTarget||document.activeElement;this.wrapper.has($(relatedTarget)).length||this.turnEditingOff(!$(relatedTarget).is(":input,a"))}),this),100)},PasswordUnmask.prototype.passwordVisible=function(){return!!this.wrapper.data("unmasked")},PasswordUnmask.prototype.isEditing=function(){return"hidden"!==this.inputField.attr("type")},PasswordUnmask.prototype.turnEditingOn=function(){var value=this.getDisplayValue();return this.passwordVisible()?this.inputField.attr("type","text"):this.inputField.attr("type","password"),this.inputField.val(value),this.inputField.attr("size",this.inputField.attr("data-size")),this.editInstructions.length&&(this.inputField.attr("aria-describedby",this.editInstructions.attr("id")),this.editInstructions.show()),this.wrapper.attr("data-passwordunmask-visible",1),this.editLink.hide(),this.inputField.focus().select(),$("body").on("focusout",this.wrapperSelector,$.proxy(this.checkFocusOut,this)),this},PasswordUnmask.prototype.turnEditingOff=function(focusOnEditLink){$("body").off("focusout",this.wrapperSelector,this.checkFocusOut);var value=this.getDisplayValue();return this.inputField.attr("type","hidden").attr("aria-describedby",null),this.inputField.val(value),this.editInstructions.hide(),this.wrapper.removeAttr("data-passwordunmask-visible"),this.inputField.removeAttr("size"),this.editLink.show(),this.setDisplayValue(),focusOnEditLink&&this.editLink.focus(),this},PasswordUnmask.prototype.getDisplayValue=function(){return this.inputField.val()},PasswordUnmask.prototype.setDisplayValue=function(){var value=this.getDisplayValue();return this.isEditing()&&(this.wrapper.data("unmasked")?this.inputField.attr("type","text"):this.inputField.attr("type","password"),this.inputField.val(value)),value&&this.wrapper.data("unmasked")?this.displayValue.text(value):(value||(value=""),Template.render("core_form/element-passwordunmask-fill",{element:{frozen:this.inputField.is("[readonly]"),value:value,valuechars:value.split("")}}).done($.proxy((function(html,js){this.displayValue.html(html),Template.runTemplateJS(js)}),this))),this},PasswordUnmask}));

//# sourceMappingURL=passwordunmask.min.js.map