/**
 * Add policy consent modal to the page
 *
 * @module     tool_policy/acceptmodal
 * @class      AcceptOnBehalf
 * @package    tool_policy
 * @copyright  2018 Marina Glancy
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_policy/acceptmodal",["jquery","core/str","core/modal_factory","core/modal_events","core/notification","core/fragment","core/ajax","core/yui"],(function($,Str,ModalFactory,ModalEvents,Notification,Fragment,Ajax,Y){var AcceptOnBehalf=function(contextid){this.contextid=contextid,this.init()};return AcceptOnBehalf.prototype.modal=null,AcceptOnBehalf.prototype.contextid=-1,AcceptOnBehalf.prototype.currentTrigger=null,AcceptOnBehalf.prototype.triggers={SINGLE:"a[data-action=acceptmodal]",BULK:"input[data-action=acceptmodal]"},AcceptOnBehalf.prototype.init=function(){$(this.triggers.SINGLE).on("click",function(e){e.preventDefault(),this.currentTrigger=$(e.currentTarget);var href=$(e.currentTarget).attr("href"),formData=href.slice(href.indexOf("?")+1);this.showFormModal(formData)}.bind(this)),$(this.triggers.BULK).on("click",function(e){e.preventDefault(),this.currentTrigger=$(e.currentTarget);var form=$(e.currentTarget).closest("form");if(form.find('input[type=checkbox][name="userids[]"]:checked').length){var formData=form.serialize();this.showFormModal(formData)}else Str.get_strings([{key:"notice"},{key:"selectusersforconsent",component:"tool_policy"},{key:"ok"}]).then((function(strings){Notification.alert(strings[0],strings[1],strings[2])})).fail(Notification.exception)}.bind(this))},AcceptOnBehalf.prototype.showFormModal=function(formData){for(var action,params=formData.split("&"),i=0;i<params.length;i++){var pair=params[i].split("=");"action"==pair[0]&&(action=pair[1])}Str.get_strings([{key:"statusformtitleaccept",component:"tool_policy"},{key:"iagreetothepolicy",component:"tool_policy"},{key:"statusformtitlerevoke",component:"tool_policy"},{key:"irevokethepolicy",component:"tool_policy"},{key:"statusformtitledecline",component:"tool_policy"},{key:"declinethepolicy",component:"tool_policy"}]).then(function(strings){var title,saveText;return"accept"==action?(title=strings[0],saveText=strings[1]):"revoke"==action?(title=strings[2],saveText=strings[3]):"decline"==action&&(title=strings[4],saveText=strings[5]),ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:title,body:""}).done(function(modal){this.modal=modal,this.setupFormModal(formData,saveText)}.bind(this))}.bind(this)).catch(Notification.exception)},AcceptOnBehalf.prototype.setupFormModal=function(formData,saveText){var modal=this.modal;modal.setLarge(),modal.setSaveButtonText(saveText),modal.getRoot().on(ModalEvents.hidden,this.destroy.bind(this)),modal.setBody(this.getBody(formData)),modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this)),modal.getRoot().on("submit","form",this.submitFormAjax.bind(this)),modal.show()},AcceptOnBehalf.prototype.getBody=function(formData){void 0===formData&&(formData={});var params={jsonformdata:JSON.stringify(formData)};return Fragment.loadFragment("tool_policy","accept_on_behalf",this.contextid,params)},AcceptOnBehalf.prototype.submitFormAjax=function(e){e.preventDefault();var formData=this.modal.getRoot().find("form").serialize();Ajax.call([{methodname:"tool_policy_submit_accept_on_behalf",args:{jsonformdata:JSON.stringify(formData)}}])[0].done(function(data){data.validationerrors?this.modal.setBody(this.getBody(formData)):this.close()}.bind(this)).fail(Notification.exception)},AcceptOnBehalf.prototype.submitForm=function(e){e.preventDefault(),this.modal.getRoot().find("form").submit()},AcceptOnBehalf.prototype.close=function(){this.destroy(),document.location.reload()},AcceptOnBehalf.prototype.destroy=function(){Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()})),this.modal.destroy(),this.currentTrigger.focus()},{getInstance:function(contextid){return new AcceptOnBehalf(contextid)}}}));

//# sourceMappingURL=acceptmodal.min.js.map