/**
 * AMD module to enable users to manage their own data requests.
 *
 * @module     tool_dataprivacy/myrequestactions
 * @package    tool_dataprivacy
 * @copyright  2018 Jun Pataleta
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_dataprivacy/myrequestactions",["jquery","core/ajax","core/notification","core/str","core/modal_factory","core/modal_events","core/templates","core/pending"],(function($,Ajax,Notification,Str,ModalFactory,ModalEvents,Templates,Pending){var ACTIONS_CANCEL_REQUEST='[data-action="cancel"]',ACTIONS_CONTACT_DPO='[data-action="contactdpo"]',MyRequestActions=function(){this.registerEvents()};return MyRequestActions.prototype.registerEvents=function(){$(ACTIONS_CANCEL_REQUEST).click((function(e){e.preventDefault();var requestId=$(this).data("requestid");Str.get_strings([{key:"cancelrequest",component:"tool_dataprivacy"},{key:"cancelrequestconfirmation",component:"tool_dataprivacy"}]).then((function(langStrings){var title=langStrings[0],confirmMessage=langStrings[1];return ModalFactory.create({title:title,body:confirmMessage,type:ModalFactory.types.SAVE_CANCEL}).then((function(modal){return modal.setSaveButtonText(title),modal.getRoot().on(ModalEvents.save,(function(){var request={methodname:"tool_dataprivacy_cancel_data_request",args:{requestid:requestId}};Ajax.call([request])[0].done((function(data){data.result?window.location.reload():Notification.addNotification({message:data.warnings[0].message,type:"error"})})).fail(Notification.exception)})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal}))})).done((function(modal){modal.show()})).fail(Notification.exception)})),$(ACTIONS_CONTACT_DPO).click((function(e){var pendingPromise=new Pending("dataprivacy/crud:initModal:contactdpo");e.preventDefault();var replyToEmail=$(this).data("replytoemail"),sendButtonText="";Str.get_strings([{key:"contactdataprotectionofficer",component:"tool_dataprivacy"},{key:"send",component:"tool_dataprivacy"}]).then((function(langStrings){var modalTitle=langStrings[0];sendButtonText=langStrings[1];var context={replytoemail:replyToEmail};return ModalFactory.create({title:modalTitle,body:Templates.render("tool_dataprivacy/contact_dpo",context),type:ModalFactory.types.SAVE_CANCEL,large:!0})})).then((function(modal){modal.setSaveButtonText(sendButtonText),modal.show(),modal.getRoot().on(ModalEvents.save,(function(e){var message=$("#message").val().trim();0===message.length?(e.preventDefault(),$('[data-region="messageinput"]').addClass("has-danger notifyproblem"),$("#id_error_message").removeAttr("hidden")):function(message){var request={methodname:"tool_dataprivacy_contact_dpo",args:{message:message}},requestType="success";Ajax.call([request])[0].then((function(data){return data.result?Str.get_string("requestsubmitted","tool_dataprivacy"):(requestType="error",data.warnings.join("<br>"))})).done((function(message){Notification.addNotification({message:message,type:requestType})})).fail(Notification.exception)}(message)})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()}))})).then(pendingPromise.resolve).catch(Notification.exception)}))},{init:function(){return new MyRequestActions}}}));

//# sourceMappingURL=myrequestactions.min.js.map