<?php
// fsconfig.phpを出力する (fs_moodle4以降）

require_once('../../../config.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/output_lib.php');

global $USER;

require_login();
if (!is_siteadmin($USER->id)) {
    echo 'このページは管理者以外は表示することができません．';
    die;
}

$action = optional_param('action', 'printout', PARAM_ALPHA);
switch ($action) {
  case 'displaycfg':
    $display_cfg    = true;
    $download_cfg   = false;
    $overwrite      = false;
    $display_opt    = false;
    $download_opt   = false;
    break;
  case 'downloadcfg':
    $display_cfg    = false;
    $download_cfg   = true;
    $overwrite      = false;
    $display_opt    = false;
    $download_opt   = false;
    break;
  case 'overwrite':
    $display_cfg    = true;
    $download_cfg   = false;
    $overwrite      = true;
    $display_opt    = false;
    $download_opt   = false;
    break;
  case 'displayopt':
    $display_cfg    = false;
    $download_cfg   = false;
    $overwrite      = false;
    $display_opt    = true;
    $download_opt   = false;
    break;
  case 'downloadopt':
    $display_cfg    = false;
    $download_cfg   = false;
    $overwrite      = false;
    $display_opt    = false;
    $download_opt   = true;
    break;
  default:
    echo 'コマンドが正しくありません．（'.$action.'）';
    die;
}

if (($download_cfg) or ($download_opt)) require_once($CFG->libdir.'/filelib.php');

if ($display_opt) {
    if (file_exists(FSCONFIGDIR.'/fsconfig_option.php')) {
        $contents = fs_file_get_contents(FSCONFIGDIR.'/fsconfig_option.php');
        if (empty($contents)) echo 'fsconfig_optionphpは空です．<br />';
          else {
            $contents = htmlentities($contents, ENT_NOQUOTES, mb_detect_encoding($contents));
            $contents = nl2br($contents);
            echo $contents;
        }
    } else {
        echo 'fsconfig_option.phpは存在しません．<br />';
    }
} else if ($download_opt) {
    if (file_exists(FSCONFIGDIR.'/fsconfig_option.php')) {
        send_file(FSCONFIGDIR.'/fsconfig_option.php', 'fsconfig_option.php');
    } else {
        echo 'fsconfig_option.phpは存在しません．<br />';
    }
} else {
    $fsout = new fsconfig_output;
    // モード選択
    if ($display_cfg) $fsout->set_display_on();     // ダウンロード用出力＋表示用出力
      else            $fsout->set_download_on();    // ダウンロード用出力のみ
    if ($overwrite)   $fsout->set_overwrite();      // 表示用出力＋上書き
    // 生成から出力まで一気に行う
    if ($overwrite) {
        $fsout->overwrite_fsconfig();
        echo '<hr>';
        echo '古いfsconfig.phpはfsconfig.bakにリネームしました．<br />';
        echo 'ウィンドウを閉じ，fs_moodleの設定表示の画面をリロードして下さい．<br />';
        echo '更新したfsconfig.phpの設定が反映されます．<br />';
    } else {
        $fsout->generate2send();
    }

    // ダウンロードボタンの表示（表示のみのモード時）
    if ($display_cfg) {
        global $SESSION, $CFG;
        echo '&nbsp;<span class="singlebutton">';
        echo '&nbsp;';
        echo '<form action="" method="POST">';
        echo '<input type="hidden" name="action" value="downloadcfg" />';
        echo '<input type="submit" value="ダウンロード" />';
        echo '</form>';
        echo '</span>';
    }
}
if (($display_cfg) || ($display_opt)) output_CloseWindowButton(true);

?>
