<?php

// ------------------------------------------------------------------------------------
// (Shirai068): fsconfig_option.phpでmimetypeを追加（上書き）可能とする改良(2008/05/30)
// ------------------------------------------------------------------------------------
// mimetypeをfsconfig.phpで追加するための関数
// Moodle2以降は$iconに拡張子を付けなくなった．そのオプションをMoodle1でも使えるように下位互換．
function fs_add_mimetype($extension, $type, $icon = false)
{
    global $CFG, $fsCFG;

    // 全て引数を小文字に変換
    $extension = trim(strtolower($extension));
    $type      = trim(strtolower($type));
    if ($icon)  $icon = trim(strtolower($icon));

    // $iconのチェック
    if (!$icon) {
        if (fs_get_major_version() < 2.0) {
            $icon = 'unknown.gif';
        } else {
            $icon = 'unknown';
        }
    } else {
        // $iconが指定されている場合
        $path_parts = fs_pathinfo($icon);
        if (fs_get_major_version() < 2.0) {
            // Moodle2.0以前（拡張子あり）
            if (empty($path_parts['extension'])) {
                // 拡張子が無いならば追加
                $icon .= '.gif';
            }
        } else {
            // Moodle2.0以降（拡張子なし）
            if (!empty($path_parts['extension'])) {
                // 拡張子があるならば取り除く
                $icon = mb_ereg_replace('\.[\w]+$', '', $icon);
            }
        }
        // iconファイルの有無のチェック
        $checkicon = $icon;
        if (fs_get_major_version() >= 2.0) $checkicon .= '.gif';
        if (!file_exists("$CFG->dirroot/pix/f/$checkicon")) $icon = 'unknown.gif';
    }

    $fsCFG->add_mimetypes[$extension] = array('type' => $type, 'icon' => $icon);
}

// ---------------------------------------------------------------------------
// (Shirai172): フッターにバナーなどを表示可能とする機能の追加 (2009/10/22)
// ---------------------------------------------------------------------------
// (1) DIV形式のバナーの追加
function fs_add_footer_banner_div($html, $courseid = -1, $option = NULL)
{
    fs_add_footer_banner_sub('html', $courseid, '<div '.$option.'>'.$html.'</div>');
}
// (2) SPAN形式のバナーの追加
function fs_add_footer_banner_span($html, $courseid = -1, $option = NULL)
{
    fs_add_footer_banner_sub('html', $courseid, '<span '.$option.'>'.$html.'</span>');
}
// (3) 生のHTML形式のバナーの追加
function fs_add_footer_banner($html, $courseid = -1)
{
    fs_add_footer_banner_sub('html', $courseid, $html);
}
// (4) PHPの関数（ユーザ定義，１関数のみコール）形式バナーの追加
function fs_add_footer_banner_func($func, $courseid = -1, $option = NULL)
{
    fs_add_footer_banner_sub('func', $courseid, $func, $option);
}
// (5) PHPのファイル読込（ユーザ作成）形式のバナーの追加：パスも忘れずに設定
function fs_add_footer_banner_php($dir, $courseid = -1)
{
    fs_add_footer_banner_sub('php', $courseid, $dir);
}
// (6) コースページのみ（フロントページ除く）バナーを表示するための指定
function fs_add_footer_banner_courseonly()
{
    global $fs_courseonly;
    $fs_courseonly = true;
}
// (7) コースページのみ（フロントページ除く）バナーを表示するための指定をキャンセルするための指定
function fs_add_footer_banner_everywhere()
{
    global $fs_courseonly;
    $fs_courseonly = false;
}
// ----
// 設定ファイルには上記５つの関数を用いて記述する（fsconfig_option.php）
function fs_add_footer_banner_sub($type, $courseid, $arg1, $arg2 = NULL)
{
    global $fsCFG, $fs_courseonly;
    switch (strtolower($type)) {
      case 'html': $footer_banner->html   = $arg1; break;
      case 'func': $footer_banner->func   = $arg1; 
                   $footer_banner->option = $arg2; break;
      case 'php' : $footer_banner->php    = $arg1; break;
      default    : return false;
    }
    $footer_banner->courseid = ($courseid < 1 ? -1 : $courseid);
    $footer_banner->courseonly = (!empty($fs_courseonly) ? true : false);
    $fsCFG->footer_banner[] = $footer_banner;
    return true;
}
// echo は echo()とも表記できるが関数ではない．fs_add_footer_banner_func()でechoを使いたい方のために用意
function uecho($option)
{
    echo $option;
}

// ----------------------------------------------------------------------------------------------
// (Shirai174): 指定されたコースのみゲストでのオートログインを可能とする機能の追加 (2009/11/05)
// ----------------------------------------------------------------------------------------------
function fs_add_autologin_guests($courseid = SITEID, $enable = true)
{
    global $fsCFG;
    if (!is_int($courseid)) return false;
    if ($courseid > 1) {
        if (! fs_get_record("course", "id", $courseid)) return false;
    } else if ($courseid != SITEID) return false;
    $fsCFG->autologin_guests[$courseid] = $enable;
    return true;
}

// ---------------------------------------------------------------------------------------------------
// (Shirai171): 特定の拡張子や指定したサイズ以上のファイルをバックアップしない機能の追加 (2009/10/08)
// ---------------------------------------------------------------------------------------------------
// 【ファイル名／フォルダ名による制限】
// （１）ファイル名による制限
function fs_add_backup_exception_filename($filename, $filesize = -1, $courseid = -1, $moddatafolder = false)
{
    return fs_add_backup_exception_filename_and_ereg($filename, $filesize, $courseid, $moddatafolder, false, false);
}
// （２）ファイル名による制限（正規表現）
function fs_add_backup_exception_filename_ereg($pattern, $filesize = -1, $courseid = -1, $moddatafolder = false)
{
    return fs_add_backup_exception_filename_and_ereg($pattern, $filesize, $courseid, $moddatafolder, false, true);
}
// （３）フォルダ名による制限：ファイルサイズは指定不可
function fs_add_backup_exception_foldername($foldername, $courseid = -1, $moddatafolder = false)
{
    return fs_add_backup_exception_filename_and_ereg($foldername, -1, $courseid, $moddatafolder, true, false);
}
// （４）フォルダ名による制限（正規表現）：ファイルサイズは指定不可
function fs_add_backup_exception_foldername_ereg($pattern, $courseid = -1, $moddatafolder = false)
{
    return fs_add_backup_exception_filename_and_ereg($pattern, -1, $courseid, $moddatafolder, true, true);
}
// 【拡張子による制限】
// （５）拡張子による制限
function fs_add_backup_exception_extension($extension, $filesize = -1, $courseid = -1, $moddatafolder = false)
{
    return fs_add_backup_exception_extension_sub($extension, $filesize, $courseid, $moddatafolder = false);
}
// 【ファイルサイズによる制限】
// （６）ファイルサイズのみによる制限
function fs_add_backup_exception_filesize($filesize, $courseid, $moddatafolder = false)
{
    return fs_add_backup_exception_filesize_sub($filesize, $courseid, $moddatafolder);
}
// -----------------------------------------------------------
// モジュールデータ（moddata）に特化した制限
// -----------------------------------------------------------
// （１）全てのモジュールデータをバックアップしない制限
function fs_add_backup_exception_mod_all($courseid = -1)
{
    fs_add_backup_exception_moddata('all', $courseid);
}
// （２）特定のモジュールデータをバックアップしない制限
function fs_add_backup_exception_mod_assignment($courseid = -1)
{
    fs_add_backup_exception_moddata('assignment', $courseid);
}
function fs_add_backup_exception_mod_chat($courseid = -1)
{
    fs_add_backup_exception_moddata('chat', $courseid);
}
function fs_add_backup_exception_mod_choice($courseid = -1)
{
    fs_add_backup_exception_moddata('choice', $courseid);
}
function fs_add_backup_exception_mod_data($courseid = -1)
{
    fs_add_backup_exception_moddata('data', $courseid);
}
function fs_add_backup_exception_mod_forum($courseid = -1)
{
    fs_add_backup_exception_moddata('forum', $courseid);
}
function fs_add_backup_exception_mod_glossary($courseid = -1)
{
    fs_add_backup_exception_moddata('glossary', $courseid);
}
function fs_add_backup_exception_mod_hotpot($courseid = -1)
{
    fs_add_backup_exception_moddata('hotpot', $courseid);
}
function fs_add_backup_exception_mod_journal($courseid = -1)
{
    fs_add_backup_exception_moddata('journal', $courseid);
}
function fs_add_backup_exception_mod_label($courseid = -1)
{
    fs_add_backup_exception_moddata('label', $courseid);
}
function fs_add_backup_exception_mod_lams($courseid = -1)
{
    fs_add_backup_exception_moddata('lams', $courseid);
}
function fs_add_backup_exception_mod_lesson($courseid = -1)
{
    fs_add_backup_exception_moddata('lesson', $courseid);
}
function fs_add_backup_exception_mod_quiz($courseid = -1)
{
    fs_add_backup_exception_moddata('quiz', $courseid);
}
function fs_add_backup_exception_mod_resource($courseid = -1)
{
    fs_add_backup_exception_moddata('resource', $courseid);
}
function fs_add_backup_exception_mod_scorm($courseid = -1)
{
    fs_add_backup_exception_moddata('scorm', $courseid);
}
function fs_add_backup_exception_mod_survey($courseid = -1)
{
    fs_add_backup_exception_moddata('survey', $courseid);
}
function fs_add_backup_exception_mod_wiki($courseid = -1)
{
    fs_add_backup_exception_moddata('wiki', $courseid);
}
function fs_add_backup_exception_mod_workshop($courseid = -1)
{
    fs_add_backup_exception_moddata('workshop', $courseid);
}
// （３）指定されたモジュールデータをバックアップしない制限
// 基本的に（１）か（２）を使用．サードパーティ製などの非標準のモジュールを使用する時のみ使用する．
function fs_add_backup_exception_moddata($modname, $courseid = -1)
{
    global $fsCFG;
    if ($courseid >= 1) {
        if (! fs_get_record("course", "id", $courseid)) return false;
    } else if ($courseid != -1) return false;
    if ($courseid >= 1) $exception->courseid = $courseid;
    $exception->modname = strtolower($modname);
    $exception->control = $fsCFG->backup_exception_control;
    $fsCFG->backup_exception[] = $exception;
}

?>