/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.robot.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class BooleanType
extends TnAbstractValueType {
    public BooleanType() {
        super(16);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return DfTypeUtil.toBoolean(rs.getObject(index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return DfTypeUtil.toBoolean(rs.getObject(columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return DfTypeUtil.toBoolean(cs.getObject(index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return DfTypeUtil.toBoolean(cs.getObject(parameterName));
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setBoolean(index, DfTypeUtil.toPrimitiveBoolean(value));
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setBoolean(parameterName, DfTypeUtil.toPrimitiveBoolean(value));
        }
    }
}

