/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.sqlcommand;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.CallbackContext;
import org.seasar.robot.dbflute.bhv.SqlStringFilter;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.robot.dbflute.outsidesql.ProcedurePmb;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnProcedureMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnProcedureParameterType;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnProcedureHandler;

public class TnProcedureCommand
extends TnAbstractBasicSqlCommand {
    protected final TnProcedureMetaData _procedureMetaData;
    protected final TnProcedureResultSetHandlerFactory _procedureResultSetHandlerFactory;
    protected OutsideSqlFilter _outsideSqlFilter;

    public TnProcedureCommand(DataSource dataSource, StatementFactory statementFactory, TnProcedureMetaData procedureMetaData, TnProcedureResultSetHandlerFactory procedureResultSetHandlerFactory) {
        super(dataSource, statementFactory);
        this.assertObjectNotNull("procedureMetaData", procedureMetaData);
        this.assertObjectNotNull("procedureResultSetHandlerFactory", procedureResultSetHandlerFactory);
        this._procedureMetaData = procedureMetaData;
        this._procedureResultSetHandlerFactory = procedureResultSetHandlerFactory;
    }

    @Override
    public Object execute(Object[] args) {
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        Object pmb = outsideSqlContext.getParameterBean();
        TnProcedureHandler handler = this.createProcedureHandler(pmb);
        Object[] onlyPmbArgs = new Object[]{pmb};
        handler.setExceptionMessageSqlArgs(onlyPmbArgs);
        return handler.execute(onlyPmbArgs);
    }

    protected TnProcedureHandler createProcedureHandler(Object pmb) {
        String sql = this.filterExecutedSql(this.buildSql(pmb));
        TnProcedureHandler.TnProcedureResultSetHandlerProvider provider = this.createProcedureResultSetHandlerProvider();
        return new TnProcedureHandler(this._dataSource, this._statementFactory, sql, this._procedureMetaData, provider);
    }

    protected String filterExecutedSql(String executedSql) {
        executedSql = this.doFilterExecutedSqlByOutsideSqlFilter(executedSql);
        executedSql = this.doFilterExecutedSqlByCallbackFilter(executedSql);
        return executedSql;
    }

    protected String doFilterExecutedSqlByOutsideSqlFilter(String executedSql) {
        if (this._outsideSqlFilter != null) {
            return this._outsideSqlFilter.filterExecution(executedSql, OutsideSqlFilter.ExecutionFilterType.PROCEDURE);
        }
        return executedSql;
    }

    protected String doFilterExecutedSqlByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterProcedure(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    protected String buildSql(Object pmb) {
        String procedureName = this._procedureMetaData.getProcedureName();
        int bindSize = this._procedureMetaData.getBindParameterTypeList().size();
        boolean existsReturn = this._procedureMetaData.hasReturnParameterType();
        return this.doBuildSql(pmb, procedureName, bindSize, existsReturn);
    }

    protected String doBuildSql(Object pmb, String procedureName, int bindSize, boolean existsReturn) {
        boolean kakou = true;
        boolean calledBySelect = false;
        if (pmb instanceof ProcedurePmb) {
            kakou = ((ProcedurePmb)pmb).isEscapeStatement();
            calledBySelect = ((ProcedurePmb)pmb).isCalledBySelect();
        }
        if (calledBySelect) {
            return this.doBuildSqlAsCalledBySelect(procedureName, bindSize);
        }
        return this.doBuildSqlAsProcedureCall(procedureName, bindSize, existsReturn, kakou);
    }

    protected String doBuildSqlAsCalledBySelect(String procedureName, int bindSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(procedureName).append("(");
        for (int i = 0; i < bindSize; ++i) {
            sb.append("?, ");
        }
        if (bindSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    protected String doBuildSqlAsProcedureCall(String procedureName, int bindSize, boolean existsReturn, boolean kakou) {
        int argSize;
        StringBuilder sb = new StringBuilder();
        if (existsReturn) {
            sb.append("? = ");
            argSize = bindSize - 1;
        } else {
            argSize = bindSize;
        }
        sb.append("call ").append(procedureName).append("(");
        for (int i = 0; i < argSize; ++i) {
            sb.append("?, ");
        }
        if (argSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        if (kakou) {
            sb.insert(0, "{").append("}");
        }
        return sb.toString();
    }

    protected TnProcedureHandler.TnProcedureResultSetHandlerProvider createProcedureResultSetHandlerProvider() {
        return new TnProcedureHandler.TnProcedureResultSetHandlerProvider(){

            @Override
            public TnResultSetHandler provideResultSetHandler(TnProcedureParameterType ppt) {
                Class<?> parameterType = ppt.getParameterType();
                if (!List.class.isAssignableFrom(parameterType)) {
                    String msg = "The parameter type for result set should be List:";
                    msg = msg + " parameter=" + ppt.getParameterName() + " type=" + parameterType;
                    throw new IllegalStateException(msg);
                }
                Class<?> elementType = ppt.getElementType();
                if (elementType == null) {
                    String msg = "The parameter type for result set should have generic type of List:";
                    msg = msg + " parameter=" + ppt.getParameterName() + " type=" + parameterType;
                    throw new IllegalStateException(msg);
                }
                if (Map.class.isAssignableFrom(elementType)) {
                    return TnProcedureCommand.this._procedureResultSetHandlerFactory.createMapHandler();
                }
                return TnProcedureCommand.this._procedureResultSetHandlerFactory.createBeanHandler(elementType);
            }
        };
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }

    public static interface TnProcedureResultSetHandlerFactory {
        public TnResultSetHandler createBeanHandler(Class<?> var1);

        public TnResultSetHandler createMapHandler();
    }
}

