/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.outsidesql;

import org.seasar.robot.dbflute.jdbc.StatementConfig;

public class OutsideSqlOption {
    protected String _pagingRequestType = "non";
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected StatementConfig _statementConfig;
    protected String _sourcePagingRequestType = "non";
    protected String _tableDbName;

    public void autoPaging() {
        this._pagingRequestType = "auto";
    }

    public void manualPaging() {
        this._pagingRequestType = "manual";
    }

    public void removeBlockComment() {
        this._removeBlockComment = true;
    }

    public void removeLineComment() {
        this._removeLineComment = true;
    }

    public void formatSql() {
        this._formatSql = true;
    }

    public String generateUniqueKey() {
        return "{" + this._pagingRequestType + "/" + this._removeBlockComment + "/" + this._removeLineComment + "/" + this._formatSql + "}";
    }

    public OutsideSqlOption copyOptionForPagingCount() {
        OutsideSqlOption copyOption = new OutsideSqlOption();
        copyOption.setPagingSourceRequestType(this._pagingRequestType);
        copyOption.setTableDbName(this._tableDbName);
        if (this._removeBlockComment) {
            copyOption.removeBlockComment();
        }
        if (this._removeLineComment) {
            copyOption.removeLineComment();
        }
        if (this._formatSql) {
            copyOption.formatSql();
        }
        if (this._statementConfig != null && this._statementConfig.hasQueryTimeout()) {
            Integer queryTimeout = this._statementConfig.getQueryTimeout();
            copyOption.setStatementConfig(new StatementConfig().queryTimeout(queryTimeout));
        }
        return copyOption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("paging=").append(this._pagingRequestType);
        if (this._statementConfig != null) {
            if (this._statementConfig.hasResultSetType()) {
                sb.append(", rs-type=").append(this._statementConfig.buildResultSetTypeDisp());
            }
            if (this._statementConfig.hasQueryTimeout()) {
                sb.append(", timeout=").append(this._statementConfig.getQueryTimeout());
            }
            if (this._statementConfig.hasFetchSize()) {
                sb.append(", fetchSize=").append(this._statementConfig.getFetchSize());
            }
            if (this._statementConfig.hasMaxRows()) {
                sb.append(", maxRows=").append(this._statementConfig.getMaxRows());
            }
        } else {
            sb.append(", config=default");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isAutoPaging() {
        return "auto".equals(this._pagingRequestType);
    }

    public boolean isManualPaging() {
        return "manual".equals(this._pagingRequestType);
    }

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public boolean isFormatSql() {
        return this._formatSql;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    protected void setPagingSourceRequestType(String sourcePagingRequestType) {
        this._sourcePagingRequestType = sourcePagingRequestType;
    }

    public boolean isSourcePagingRequestTypeAuto() {
        return "auto".equals(this._sourcePagingRequestType);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }
}

