/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.jdbc;

import org.seasar.robot.dbflute.util.DfTraceViewUtil;

public class ExecutionTimeInfo {
    protected final Long _commandBeforeTimeMillis;
    protected final Long _commandAfterTimeMillis;
    protected final Long _sqlBeforeTimeMillis;
    protected final Long _sqlAfterTimeMillis;

    public ExecutionTimeInfo(Long commandBeforeTimeMillis, Long commandAfterTimeMillis, Long sqlBeforeTimeMillis, Long sqlAfterTimeMillis) {
        this._commandBeforeTimeMillis = commandBeforeTimeMillis;
        this._commandAfterTimeMillis = commandAfterTimeMillis;
        this._sqlBeforeTimeMillis = sqlBeforeTimeMillis;
        this._sqlAfterTimeMillis = sqlAfterTimeMillis;
    }

    public String toCommandPerformanceView() {
        if (this.hasCommandTimeMillis()) {
            return this.convertToPerformanceView(this._commandAfterTimeMillis - this._commandBeforeTimeMillis);
        }
        return "*No time";
    }

    public String toSqlPerformanceView() {
        if (this.hasSqlTimeMillis()) {
            return this.convertToPerformanceView(this._sqlAfterTimeMillis - this._sqlBeforeTimeMillis);
        }
        return "*No time";
    }

    protected String convertToPerformanceView(long after_minus_before) {
        return DfTraceViewUtil.convertToPerformanceView(after_minus_before);
    }

    public boolean hasCommandTimeMillis() {
        return this._commandAfterTimeMillis != null && this._commandBeforeTimeMillis != null;
    }

    public boolean hasSqlTimeMillis() {
        return this._sqlAfterTimeMillis != null && this._sqlBeforeTimeMillis != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("commandBefore=").append(this._commandBeforeTimeMillis);
        sb.append(", commandAfter=").append(this._commandAfterTimeMillis);
        sb.append(", sqlBefore=").append(this._sqlBeforeTimeMillis);
        sb.append(", sqlAfter=").append(this._sqlAfterTimeMillis);
        sb.append("}");
        return sb.toString();
    }

    public Long getCommandBeforeTimeMillis() {
        return this._commandBeforeTimeMillis;
    }

    public Long getCommandAfterTimeMillis() {
        return this._commandAfterTimeMillis;
    }

    public Long getSqlBeforeTimeMillis() {
        return this._sqlBeforeTimeMillis;
    }

    public Long getSqlAfterTimeMillis() {
        return this._sqlAfterTimeMillis;
    }
}

