/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.stacktrace;

import java.util.ArrayList;
import java.util.List;
import org.seasar.robot.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.robot.dbflute.helper.stacktrace.InvokeNameResult;

public class InvokeNameExtractor {
    protected final StackTraceElement[] _stackTrace;

    public InvokeNameExtractor(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            String msg = "The argument 'stackTrace' should not be null.";
            throw new IllegalStateException(msg);
        }
        this._stackTrace = stackTrace;
    }

    public List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource) {
        ArrayList<InvokeNameResult> resultList = new ArrayList<InvokeNameResult>();
        String simpleClassName = null;
        String methodName = null;
        int lineNumber = 0;
        int foundIndex = -1;
        int foundFirstIndex = -1;
        boolean onTarget = false;
        boolean existsDuplicate = false;
        int startIndex = resource.getStartIndex();
        if (startIndex < 0) {
            return new ArrayList<InvokeNameResult>(2);
        }
        int loopSize = resource.getLoopSize();
        if (startIndex < 0) {
            return new ArrayList<InvokeNameResult>(2);
        }
        for (int i = startIndex; i < this._stackTrace.length; ++i) {
            StackTraceElement element = this._stackTrace[i];
            if (i > startIndex + loopSize) break;
            String currentClassName = element.getClassName();
            if (currentClassName.startsWith("sun.") || currentClassName.startsWith("java.")) {
                if (!onTarget) continue;
                break;
            }
            String currentMethodName = element.getMethodName();
            if (resource.isTargetElement(currentClassName, currentMethodName)) {
                if (currentMethodName.equals("invoke")) continue;
                simpleClassName = currentClassName.substring(currentClassName.lastIndexOf(".") + 1);
                simpleClassName = resource.filterSimpleClassName(simpleClassName);
                methodName = currentMethodName;
                if (resource.isUseAdditionalInfo()) {
                    lineNumber = element.getLineNumber();
                }
                foundIndex = i;
                if (foundFirstIndex == -1) {
                    foundFirstIndex = i;
                }
                onTarget = true;
                if (resultList.isEmpty()) {
                    resultList.add(this.createResult(simpleClassName, methodName, lineNumber, foundIndex, foundFirstIndex));
                    continue;
                }
                existsDuplicate = true;
                continue;
            }
            if (onTarget) break;
        }
        if (simpleClassName == null) {
            return new ArrayList<InvokeNameResult>(2);
        }
        if (existsDuplicate) {
            resultList.add(this.createResult(simpleClassName, methodName, lineNumber, foundIndex, foundFirstIndex));
        }
        return resultList;
    }

    private InvokeNameResult createResult(String simpleClassName, String methodName, int lineNumber, int foundIndex, int foundFirstIndex) {
        InvokeNameResult result = new InvokeNameResult();
        result.setSimpleClassName(simpleClassName);
        result.setMethodName(methodName);
        result.setLineNumber(lineNumber);
        result.setFoundIndex(foundIndex);
        result.setFoundFirstIndex(foundFirstIndex);
        return result;
    }
}

