/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ProcessConsoleReader
extends Thread {
    protected final BufferedReader _reader;
    protected final StringBuilder _consoleSb = new StringBuilder();

    public ProcessConsoleReader(InputStream ins, String encoding) {
        encoding = encoding != null ? encoding : "UTF-8";
        try {
            this._reader = new BufferedReader(new InputStreamReader(ins, encoding));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Failed to create a reader by the encoding: " + encoding;
            throw new IllegalStateException(msg);
        }
    }

    public String read() {
        return this._consoleSb.toString();
    }

    @Override
    public void run() {
        StringBuilder sb = this._consoleSb;
        try {
            String line;
            while ((line = this._reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
        }
        catch (IOException e) {
            String msg = "Failed to read the stream: " + this._reader;
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                this._reader.close();
            }
            catch (IOException ignored) {}
        }
    }
}

