/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.jprop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.helper.jprop.JavaPropertiesProperty;
import org.seasar.robot.dbflute.helper.jprop.JavaPropertiesResult;
import org.seasar.robot.dbflute.helper.jprop.JavaPropertiesStreamProvider;
import org.seasar.robot.dbflute.helper.jprop.exception.JavaPropertiesImplicitOverrideException;
import org.seasar.robot.dbflute.helper.jprop.exception.JavaPropertiesLonelyOverrideException;
import org.seasar.robot.dbflute.helper.jprop.exception.JavaPropertiesReadFailureException;
import org.seasar.robot.dbflute.helper.jprop.exception.JavaPropertiesStreamNotFoundException;
import org.seasar.robot.dbflute.util.DfCollectionUtil;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.Srl;

public class JavaPropertiesReader {
    public static final String OVERRIDE_ANNOTATION = "@Override";
    public static final String SECURE_ANNOTATION = "@Secure";
    protected final String _title;
    protected final JavaPropertiesStreamProvider _streamProvider;
    protected final Map<String, JavaPropertiesStreamProvider> _extendsProviderMap = this.newLinkedHashMapSized(4);
    protected boolean _checkImplicitOverride;
    protected Method _convertMethod;
    protected boolean _convertMethodNotFound;
    protected final Properties _reflectionProperties = new Properties();

    public JavaPropertiesReader(String title, JavaPropertiesStreamProvider streamProvider) {
        this._title = title;
        this._streamProvider = streamProvider;
    }

    public JavaPropertiesReader extendsProperties(String title, JavaPropertiesStreamProvider extendsStreamProvider) {
        if (this._extendsProviderMap.containsKey(title)) {
            String msg = "The argument 'title' has already been registered:";
            msg = msg + " title=" + title + " registered=" + this._extendsProviderMap.keySet();
            throw new IllegalArgumentException(msg);
        }
        this._extendsProviderMap.put(title, extendsStreamProvider);
        return this;
    }

    public JavaPropertiesReader checkImplicitOverride() {
        this._checkImplicitOverride = true;
        return this;
    }

    public JavaPropertiesResult read() {
        ArrayList<JavaPropertiesProperty> propertyList = this.newArrayList();
        ArrayList<String> duplicateKeyList = this.newArrayList();
        Map<String, String> keyCommentMap = this.readKeyCommentMap(duplicateKeyList);
        Properties prop = this.readPlainProperties();
        List<String> keyList = this.orderKeyList(prop, keyCommentMap);
        for (String key : keyList) {
            String value = prop.getProperty(key);
            String comment = keyCommentMap.get(key);
            JavaPropertiesProperty property = new JavaPropertiesProperty(key, value);
            String defName = Srl.replace(key, ".", "_").toUpperCase();
            property.setDefName(defName);
            String camelizedName = Srl.camelize(defName);
            property.setCamelizedName(camelizedName);
            property.setCapCamelName(Srl.initCap(camelizedName));
            property.setUncapCamelName(Srl.initUncap(camelizedName));
            ArrayList variableScopeList = this.newArrayList();
            List<Object> scopeList = Srl.is_NotNull_and_NotTrimmedEmpty(value) ? Srl.extractScopeList(value, "{", "}") : DfCollectionUtil.emptyList();
            for (Srl.ScopeInfo scopeInfo : scopeList) {
                String content = scopeInfo.getContent();
                try {
                    Integer.valueOf(content);
                    variableScopeList.add(scopeInfo);
                }
                catch (NumberFormatException ignored) {}
            }
            ArrayList<Integer> variableNumberList = DfCollectionUtil.newArrayList();
            for (Srl.ScopeInfo scopeInfo : variableScopeList) {
                variableNumberList.add(this.valueOfVariableNumber(key, scopeInfo.getContent()));
            }
            property.setVariableArgDef(this.buildVariableArgDef(variableNumberList));
            property.setVariableArgSet(this.buildVariableArgSet(variableNumberList));
            property.setVariableNumberList(variableNumberList);
            property.setComment(comment);
            if (this.containsSecureAnnotation(property)) {
                property.toBeSecure();
            }
            propertyList.add(property);
        }
        return this.prepareResult(prop, propertyList, duplicateKeyList);
    }

    protected boolean containsSecureAnnotation(JavaPropertiesProperty property) {
        String comment = property.getComment();
        return comment != null && Srl.containsIgnoreCase(comment, SECURE_ANNOTATION);
    }

    protected List<String> orderKeyList(Properties prop, Map<String, String> keyCommentMap) {
        ArrayList<Object> orderedList = this.newArrayList(prop.keySet());
        DfCollectionUtil.AccordingToOrderResource<Object, String> resource = new DfCollectionUtil.AccordingToOrderResource<Object, String>();
        resource.setIdExtractor(new DfCollectionUtil.AccordingToOrderIdExtractor<Object, String>(){

            @Override
            public String extractId(Object element) {
                return (String)element;
            }
        });
        resource.setOrderedUniqueIdList(this.newArrayList(keyCommentMap.keySet()));
        DfCollectionUtil.orderAccordingTo(orderedList, resource);
        ArrayList<String> keyList = this.newArrayList();
        for (Object e : orderedList) {
            keyList.add((String)e);
        }
        return keyList;
    }

    protected JavaPropertiesResult prepareResult(Properties prop, List<JavaPropertiesProperty> propertyList, List<String> duplicateKeyList) {
        JavaPropertiesResult propResult;
        if (!this._extendsProviderMap.isEmpty()) {
            JavaPropertiesReader extendsReader = this.createExtendsReader();
            JavaPropertiesResult extendsPropResult = extendsReader.read();
            List<JavaPropertiesProperty> mergedList = this.mergeExtendsPropResult(propertyList, extendsPropResult);
            propResult = new JavaPropertiesResult(prop, mergedList, duplicateKeyList, extendsPropResult);
        } else {
            propResult = new JavaPropertiesResult(prop, propertyList, duplicateKeyList);
        }
        return propResult;
    }

    protected JavaPropertiesReader createExtendsReader() {
        LinkedHashMap<String, JavaPropertiesStreamProvider> providerMap = this.newLinkedHashMap(this._extendsProviderMap);
        Map.Entry firstEntry = providerMap.entrySet().iterator().next();
        String firstKey = (String)firstEntry.getKey();
        JavaPropertiesStreamProvider firstProvider = (JavaPropertiesStreamProvider)firstEntry.getValue();
        JavaPropertiesReader extendsReader = new JavaPropertiesReader(firstKey, firstProvider);
        providerMap.remove(firstKey);
        for (Map.Entry entry : providerMap.entrySet()) {
            extendsReader.extendsProperties((String)entry.getKey(), (JavaPropertiesStreamProvider)entry.getValue());
        }
        if (this._checkImplicitOverride) {
            extendsReader.checkImplicitOverride();
        }
        return extendsReader;
    }

    protected List<JavaPropertiesProperty> mergeExtendsPropResult(List<JavaPropertiesProperty> propertyList, JavaPropertiesResult extendsPropResult) {
        List<JavaPropertiesProperty> extendsPropertyList = extendsPropResult.getPropertyList();
        for (JavaPropertiesProperty property : extendsPropertyList) {
            property.toBeExtends();
        }
        Map<String, JavaPropertiesProperty> extendsPropertyMap = this.toPropertyMap(extendsPropertyList);
        for (JavaPropertiesProperty property : propertyList) {
            String propertyKey = property.getPropertyKey();
            if (extendsPropertyMap.containsKey(propertyKey)) {
                property.toBeOverride();
                this.checkImplicitOverride(property);
                JavaPropertiesProperty extendsProperty = extendsPropertyMap.get(propertyKey);
                this.inheritSecure(property, extendsProperty);
                this.inheritComment(property, extendsProperty);
                continue;
            }
            this.checkLonelyOverride(property);
        }
        LinkedHashSet<JavaPropertiesProperty> mergedPropertySet = DfCollectionUtil.newLinkedHashSet(propertyList);
        mergedPropertySet.addAll(extendsPropertyMap.values());
        return DfCollectionUtil.newArrayList(mergedPropertySet);
    }

    protected Map<String, JavaPropertiesProperty> toPropertyMap(List<JavaPropertiesProperty> propertyList) {
        LinkedHashMap<String, JavaPropertiesProperty> propertyMap = DfCollectionUtil.newLinkedHashMap();
        for (JavaPropertiesProperty property : propertyList) {
            propertyMap.put(property.getPropertyKey(), property);
        }
        return propertyMap;
    }

    protected void checkImplicitOverride(JavaPropertiesProperty property) {
        if (this._checkImplicitOverride && !this.containsOverrideAnnotation(property)) {
            this.throwJavaPropertiesImplicitOverrideException(property);
        }
    }

    protected void checkLonelyOverride(JavaPropertiesProperty property) {
        if (this._checkImplicitOverride && this.containsOverrideAnnotation(property)) {
            this.throwJavaPropertiesLonelyOverrideException(property);
        }
    }

    protected boolean containsOverrideAnnotation(JavaPropertiesProperty property) {
        String comment = property.getComment();
        return comment != null && Srl.containsIgnoreCase(comment, OVERRIDE_ANNOTATION);
    }

    protected void inheritSecure(JavaPropertiesProperty property, JavaPropertiesProperty extendsProperty) {
        if (extendsProperty.isSecure()) {
            property.toBeSecure();
        }
    }

    protected void inheritComment(JavaPropertiesProperty property, JavaPropertiesProperty extendsProperty) {
        String comment = property.getComment();
        if (this.hasCommentIgnoreAnnotation(comment)) {
            return;
        }
        String extendsPureComment = this.extractPureComment(extendsProperty.getComment());
        if (Srl.is_Null_or_TrimmedEmpty(extendsPureComment)) {
            return;
        }
        String baseComment = Srl.is_NotNull_and_NotTrimmedEmpty(comment) ? comment + " " : "";
        property.setComment(baseComment + extendsPureComment);
    }

    protected boolean hasCommentIgnoreAnnotation(String comment) {
        if (Srl.is_Null_or_TrimmedEmpty(comment)) {
            return false;
        }
        String replaced = this.extractPureComment(comment);
        return Srl.is_NotNull_and_NotTrimmedEmpty(replaced);
    }

    protected String extractPureComment(String comment) {
        if (Srl.is_Null_or_TrimmedEmpty(comment)) {
            return comment;
        }
        HashMap<String, String> fromToMap = new HashMap<String, String>();
        fromToMap.put(OVERRIDE_ANNOTATION, "");
        fromToMap.put(SECURE_ANNOTATION, "");
        return Srl.replaceBy(comment, fromToMap);
    }

    protected void throwJavaPropertiesImplicitOverrideException(JavaPropertiesProperty property) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Found the implicit override property.");
        br.addItem("Advice");
        br.addElement("The property overrides the inherited property.");
        br.addElement("Do you want to override it? Or is it your mistake?");
        br.addElement("If you override it, set the annotation @Override in the property.");
        br.addElement("For example:");
        br.addElement("  # @Override");
        br.addElement("  foo.bar.prop = abc");
        br.addItem("Properties");
        br.addElement(this._title);
        br.addItem("Implicit Override Property");
        br.addElement(property.getPropertyKey());
        br.addElement(property.getPropertyValue());
        String msg = br.buildExceptionMessage();
        throw new JavaPropertiesImplicitOverrideException(msg);
    }

    protected void throwJavaPropertiesLonelyOverrideException(JavaPropertiesProperty property) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Found the lonely override property.");
        br.addItem("Advice");
        br.addElement("The property does not override any inherited property");
        br.addElement("but the property have the annotation @Override.");
        br.addElement("Remove the annotation or fix the mistake of the property key.");
        br.addItem("Properties");
        br.addElement(this._title);
        br.addItem("Lonely Override Property");
        br.addElement(property.getPropertyKey());
        br.addElement(property.getPropertyValue());
        String msg = br.buildExceptionMessage();
        throw new JavaPropertiesLonelyOverrideException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> readKeyCommentMap(List<String> duplicateKeyList) {
        LinkedHashMap<String, String> keyCommentMap = DfCollectionUtil.newLinkedHashMap();
        String encoding = "UTF-8";
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.preparePropFileStream(), "UTF-8"));
            String previousComment = null;
            while ((line = br.readLine()) != null) {
                String ltrimmedLine = Srl.ltrim(line);
                if (ltrimmedLine.startsWith("# ")) {
                    String commentCandidate = Srl.substringFirstRear(ltrimmedLine, "#").trim();
                    if (ltrimmedLine.contains("=")) {
                        previousComment = null;
                        continue;
                    }
                    if (ltrimmedLine.trim().equals("#")) continue;
                    previousComment = commentCandidate;
                    continue;
                }
                if (!ltrimmedLine.contains("=")) continue;
                String key = Srl.substringFirstFront(ltrimmedLine, "=").trim();
                if (keyCommentMap.containsKey(key)) {
                    duplicateKeyList.add(key);
                    keyCommentMap.remove(key);
                }
                keyCommentMap.put(key, this.loadConvert(previousComment));
                previousComment = null;
            }
        }
        catch (IOException e) {
            this.throwJavaPropertiesReadFailureException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        return keyCommentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readPlainProperties() {
        Properties prop = new Properties();
        InputStream ins = null;
        try {
            ins = this.preparePropFileStream();
            prop.load(ins);
        }
        catch (IOException e) {
            this.throwJavaPropertiesReadFailureException(e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    protected InputStream preparePropFileStream() throws IOException {
        InputStream stream = this._streamProvider.provideStream();
        if (stream == null) {
            this.throwJavaPropertiesStreamNotFoundException();
        }
        return stream;
    }

    protected void throwJavaPropertiesStreamNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the steram for the properties file.");
        br.addItem("Advice");
        br.addElement("The stream provider should not return null but null returned.");
        br.addElement("Make sure your resource path for the properties.");
        br.addItem("Properties");
        br.addElement(this._title);
        br.addItem("Stream Provider");
        br.addElement(this._streamProvider);
        String msg = br.buildExceptionMessage();
        throw new JavaPropertiesStreamNotFoundException(msg);
    }

    protected void throwJavaPropertiesReadFailureException(IOException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the properties file.");
        br.addItem("Properties");
        br.addElement(this._title);
        br.addItem("IOException");
        br.addElement(e.getClass().getName());
        br.addElement(e.getMessage());
        String msg = br.buildExceptionMessage();
        throw new JavaPropertiesReadFailureException(msg, e);
    }

    protected Integer valueOfVariableNumber(String key, String content) {
        try {
            return Integer.valueOf(content);
        }
        catch (NumberFormatException e) {
            String msg = "The NOT-number variable was found: provider=" + this._streamProvider + " key=" + key;
            throw new IllegalStateException(msg, e);
        }
    }

    protected String buildVariableArgDef(List<Integer> variableNumberList) {
        StringBuilder sb = new StringBuilder();
        for (Integer number : variableNumberList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("String arg").append(number);
        }
        return sb.toString();
    }

    protected String buildVariableArgSet(List<Integer> variableNumberList) {
        StringBuilder sb = new StringBuilder();
        for (Integer number : variableNumberList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("arg").append(number);
        }
        return sb.toString();
    }

    protected String loadConvert(String expression) {
        if (expression == null) {
            return null;
        }
        Method method = this.getConvertMethod();
        if (method == null) {
            return expression;
        }
        char[] in = expression.toCharArray();
        Object[] args = new Object[]{in, 0, expression.length(), new char[0]};
        return (String)DfReflectionUtil.invoke(method, this._reflectionProperties, args);
    }

    protected Method getConvertMethod() {
        if (this._convertMethod != null) {
            return this._convertMethod;
        }
        if (this._convertMethodNotFound) {
            return null;
        }
        Class[] argTypes = new Class[]{char[].class, Integer.TYPE, Integer.TYPE, char[].class};
        this._convertMethod = DfReflectionUtil.getWholeMethod(Properties.class, "loadConvert", argTypes);
        if (this._convertMethod == null) {
            this._convertMethodNotFound = true;
        } else {
            this._convertMethod.setAccessible(true);
        }
        return this._convertMethod;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return DfCollectionUtil.newArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> elements) {
        return DfCollectionUtil.newArrayList(elements);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(Map<KEY, VALUE> map) {
        return DfCollectionUtil.newLinkedHashMap(map);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMapSized(int size) {
        return DfCollectionUtil.newLinkedHashMapSized(size);
    }
}

