/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause.subquery;

import org.seasar.robot.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryClause;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.robot.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.robot.dbflute.resource.DBFluteSystem;
import org.seasar.robot.dbflute.util.Srl;

public abstract class AbstractSubQuery {
    protected final SubQueryPath _subQueryPath;
    protected final ColumnRealNameProvider _localRealNameProvider;
    protected final ColumnSqlNameProvider _subQuerySqlNameProvider;
    protected final int _subQueryLevel;
    protected final SqlClause _subQuerySqlClause;
    protected final String _subQueryIdentity;
    protected final DBMeta _subQueryDBMeta;
    protected final GearedCipherManager _cipherManager;

    public AbstractSubQuery(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager) {
        this._subQueryPath = subQueryPath;
        this._localRealNameProvider = localRealNameProvider;
        this._subQuerySqlNameProvider = subQuerySqlNameProvider;
        this._subQueryLevel = subQueryLevel;
        this._subQuerySqlClause = subQuerySqlClause;
        this._subQueryIdentity = subQueryIdentity;
        this._subQueryDBMeta = subQueryDBMeta;
        this._cipherManager = cipherManager;
    }

    protected String getSubQueryLocalAliasName() {
        return this._subQuerySqlClause.getBasePointAliasName();
    }

    protected String buildSubQueryMainAliasName() {
        return "sub" + this._subQueryLevel + "main";
    }

    protected String resolveSubQueryLevelVariable(String subQueryClause) {
        return this.replace(subQueryClause, "${subQueryLevel}", String.valueOf(this._subQueryLevel));
    }

    protected String buildPlainFromWhereClause(String selectClause, String localAliasName, String correlatedFixedCondition) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildPlainSubQueryFromWhereClause(correlatedFixedCondition);
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String localAliasName, ColumnRealName correlatedColumnRealName, ColumnSqlName relatedColumnSqlName, String correlatedFixedCondition) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(correlatedColumnRealName, relatedColumnSqlName, correlatedFixedCondition);
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String localAliasName, ColumnRealName[] correlatedColumnRealNames, ColumnSqlName[] relatedColumnSqlNames, String correlatedFixedCondition) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(correlatedColumnRealNames, relatedColumnSqlNames, correlatedFixedCondition);
    }

    protected SubQueryClause createSubQueryClause(String selectClause, String localAliasName) {
        return new SubQueryClause(this._subQueryPath, selectClause, this._subQuerySqlClause, localAliasName);
    }

    protected String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this._subQuerySqlClause.resolveSubQueryBeginMark(subQueryIdentity);
    }

    protected String resolveSubQueryEndMark(String subQueryIdentity) {
        return this._subQuerySqlClause.resolveSubQueryEndMark(subQueryIdentity);
    }

    protected ColumnFunctionCipher findColumnFunctionCipher(ColumnInfo columnInfo) {
        return this._cipherManager != null ? this._cipherManager.findColumnFunctionCipher(columnInfo) : null;
    }

    protected String decrypt(ColumnInfo columnInfo, String valueExp) {
        ColumnFunctionCipher cipher = this.findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected final String initCap(String str) {
        return Srl.initCap(str);
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected final String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public SubQueryPath getSubQueryPath() {
        return this._subQueryPath;
    }

    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    public SqlClause getSubQuerySqlClause() {
        return this._subQuerySqlClause;
    }
}

