/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.robot.dbflute.bhv.core.command.AbstractOutsideSqlSelectCommand;
import org.seasar.robot.dbflute.jdbc.CursorHandler;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;

public class OutsideSqlSelectCursorCommand
extends AbstractOutsideSqlSelectCommand<Object> {
    protected CursorHandler _cursorHandler;

    @Override
    public String getCommandName() {
        return "selectCursor";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Object.class;
    }

    @Override
    public boolean isSelectCursor() {
        return true;
    }

    @Override
    protected void setupOutsideSqlContextProperty(OutsideSqlContext outsideSqlContext) {
        super.setupOutsideSqlContextProperty(outsideSqlContext);
        outsideSqlContext.setCursorHandler(this._cursorHandler);
    }

    @Override
    protected Class<?> getResultType() {
        return this._cursorHandler.getClass();
    }

    @Override
    protected TnResultSetHandler createOutsideSqlSelectResultSetHandler() {
        return new TnResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                if (!OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
                    String msg = "The context of outside SQL should be required here!";
                    throw new IllegalStateException(msg);
                }
                OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
                CursorHandler cursorHandler = context.getCursorHandler();
                return cursorHandler.handle(rs);
            }
        };
    }

    @Override
    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        this.assertOutsideSqlBasic(methodName);
        if (this._cursorHandler == null) {
            throw new IllegalStateException(this.buildAssertMessage("_cursorHandler", methodName));
        }
    }

    public void setCursorHandler(CursorHandler cursorHandler) {
        this._cursorHandler = cursorHandler;
    }
}

