/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute;

import org.seasar.robot.dbflute.bhv.SqlStringFilter;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandHook;
import org.seasar.robot.dbflute.bhv.core.SqlFireHook;
import org.seasar.robot.dbflute.jdbc.SqlLogHandler;
import org.seasar.robot.dbflute.jdbc.SqlResultHandler;

public class CallbackContext {
    private static final ThreadLocal<CallbackContext> _threadLocal = new ThreadLocal();
    protected BehaviorCommandHook _behaviorCommandHook;
    protected SqlFireHook _sqlFireHook;
    protected SqlLogHandler _sqlLogHandler;
    protected SqlResultHandler _sqlResultHandler;
    protected SqlStringFilter _sqlStringFilter;

    public static CallbackContext getCallbackContextOnThread() {
        return _threadLocal.get();
    }

    public static void setCallbackContextOnThread(CallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument[callbackContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearCallbackContextOnThread() {
        _threadLocal.set(null);
    }

    public static void setBehaviorCommandHookOnThread(BehaviorCommandHook behaviorCommandHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setBehaviorCommandHook(behaviorCommandHook);
    }

    public static boolean isExistBehaviorCommandHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook() != null;
    }

    public static void clearBehaviorCommandHookOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setBehaviorCommandHook(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlFireHookOnThread(SqlFireHook sqlFireHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlFireHook(sqlFireHook);
    }

    public static boolean isExistSqlFireHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlFireHook() != null;
    }

    public static void clearSqlFireHookOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlFireHook(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlLogHandlerOnThread(SqlLogHandler sqlLogHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlLogHandler(sqlLogHandler);
    }

    public static boolean isExistSqlLogHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlLogHandler() != null;
    }

    public static void clearSqlLogHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlLogHandler(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlResultHandlerOnThread(SqlResultHandler sqlResultHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlResultHandler(sqlResultHandler);
    }

    public static boolean isExistSqlResultHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlResultHandler() != null;
    }

    public static void clearSqlResultHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlResultHandler(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlStringFilterOnThread(SqlStringFilter sqlStringFilter) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlStringFilter(sqlStringFilter);
    }

    public static boolean isExistSqlStringFilterOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlStringFilter() != null;
    }

    public static void clearSqlStringFilterOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlStringFilter(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    protected static CallbackContext getOrCreateContext() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            return CallbackContext.getCallbackContextOnThread();
        }
        CallbackContext context = new CallbackContext();
        CallbackContext.setCallbackContextOnThread(context);
        return context;
    }

    protected static void clearIfNoInterface(CallbackContext context) {
        if (!context.hasAnyInterface()) {
            CallbackContext.clearCallbackContextOnThread();
        }
    }

    public boolean hasAnyInterface() {
        return this._behaviorCommandHook != null || this._sqlFireHook != null || this._sqlLogHandler != null || this._sqlResultHandler != null || this._sqlStringFilter != null;
    }

    public BehaviorCommandHook getBehaviorCommandHook() {
        return this._behaviorCommandHook;
    }

    public void setBehaviorCommandHook(BehaviorCommandHook behaviorCommandHook) {
        this._behaviorCommandHook = behaviorCommandHook;
    }

    public SqlFireHook getSqlFireHook() {
        return this._sqlFireHook;
    }

    public void setSqlFireHook(SqlFireHook sqlFireHook) {
        this._sqlFireHook = sqlFireHook;
    }

    public SqlLogHandler getSqlLogHandler() {
        return this._sqlLogHandler;
    }

    public void setSqlLogHandler(SqlLogHandler sqlLogHandler) {
        this._sqlLogHandler = sqlLogHandler;
    }

    public SqlResultHandler getSqlResultHandler() {
        return this._sqlResultHandler;
    }

    public void setSqlResultHandler(SqlResultHandler sqlResultHandler) {
        this._sqlResultHandler = sqlResultHandler;
    }

    public SqlStringFilter getSqlStringFilter() {
        return this._sqlStringFilter;
    }

    public void setSqlStringFilter(SqlStringFilter sqlStringFilter) {
        this._sqlStringFilter = sqlStringFilter;
    }
}

