/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class UnicodeString {
    public static UnicodeString EMPTY_STRING = new GeneralUnicodeString("");

    public static UnicodeString makeUnicodeString(CharSequence in) {
        if (UnicodeString.containsSurrogatePairs(in)) {
            return new GeneralUnicodeString(in);
        }
        return new BMPString(in);
    }

    public static UnicodeString makeUnicodeString(int[] in) {
        for (int ch : in) {
            if (ch <= 65535) continue;
            return new GeneralUnicodeString(in, 0, in.length);
        }
        FastStringBuffer fsb = new FastStringBuffer(in.length);
        for (int ch : in) {
            fsb.append((char)ch);
        }
        return new BMPString(fsb);
    }

    public static boolean containsSurrogatePairs(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < '\ud800' || c > '\udbff') continue;
            return true;
        }
        return false;
    }

    public abstract UnicodeString substring(int var1, int var2);

    public abstract int indexOf(int var1, int var2);

    public abstract int charAt(int var1);

    public abstract int length();

    public abstract boolean isEnd(int var1);

    public abstract CharSequence getCharSequence();
}

