/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public abstract class SingleNodeExpression
extends Expression {
    private boolean contextMaybeUndefined = true;

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (contextItemType == null || contextItemType.itemType == null) {
            XPathException err = new XPathException(this.noContextMessage() + ": the context item is absent");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.contextMaybeUndefined = contextItemType.contextMaybeUndefined;
        if (contextItemType.itemType.isPlainType()) {
            XPathException err = new XPathException(this.noContextMessage() + ": the context item is an atomic value");
            err.setErrorCode("XPTY0020");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    protected abstract String noContextMessage();

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        return this.typeCheck(visitor, contextItemType);
    }

    public int computeCardinality() {
        return 24576;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyNodeTest.getInstance();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0xC30000;
    }

    public abstract NodeInfo getNode(XPathContext var1) throws XPathException;

    public boolean isContextPossiblyUndefined() {
        return this.contextMaybeUndefined;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.getNode(context));
    }

    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        return this.getNode(context);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.getNode(context) != null;
    }
}

