/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadJsonBuilder
implements CommandBuilder {
    public static final String MIME_TYPE = "json/java+memory";

    public Collection<String> getNames() {
        return Collections.singletonList("readJson");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadJson(this, config, parent, child, context);
    }

    private static final class ReadJson
    extends AbstractParser {
        private final ObjectReader reader;

        public ReadJson(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Class<?> outputClass;
            JsonFactory jsonFactory = null;
            String jsonFactoryClassName = this.getConfigs().getString(config, "jsonFactory", null);
            if (jsonFactoryClassName != null) {
                try {
                    jsonFactory = (JsonFactory)Class.forName(jsonFactoryClassName).newInstance();
                }
                catch (Exception e) {
                    throw new MorphlineCompilationException("Cannot create instance", config, (Throwable)e);
                }
            }
            String objectMapperClassName = this.getConfigs().getString(config, "objectMapper", null);
            ObjectMapper objectMapper = null;
            if (objectMapperClassName != null) {
                try {
                    objectMapper = (ObjectMapper)Class.forName(objectMapperClassName).newInstance();
                }
                catch (Exception e) {
                    throw new MorphlineCompilationException("Cannot create instance", config, (Throwable)e);
                }
            } else {
                objectMapper = new ObjectMapper(jsonFactory);
            }
            String outputClassName = this.getConfigs().getString(config, "outputClass", JsonNode.class.getName());
            try {
                outputClass = Class.forName(outputClassName);
            }
            catch (ClassNotFoundException e) {
                throw new MorphlineCompilationException("Class not found", config, (Throwable)e);
            }
            this.reader = objectMapper.reader(outputClass);
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record inputRecord, InputStream in) throws IOException {
            Record template = inputRecord.copy();
            ReadJson.removeAttachments((Record)template);
            MappingIterator iter = this.reader.readValues(in);
            try {
                while (iter.hasNextValue()) {
                    Object rootNode = iter.nextValue();
                    this.incrementNumRecords();
                    this.LOG.trace("jsonObject: {}", rootNode);
                    Record outputRecord = template.copy();
                    outputRecord.put("_attachment_body", rootNode);
                    outputRecord.put("_attachment_mimetype", (Object)ReadJsonBuilder.MIME_TYPE);
                    if (this.getChild().process(outputRecord)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                iter.close();
            }
        }
    }
}

