/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.shaded.com.google.code.regexp.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrokDictionaries {
    private final Config config;
    private final Map<String, String> dictionary = new HashMap<String, String>();
    private final Logger LOG = LoggerFactory.getLogger(GrokDictionaries.class);

    public GrokDictionaries(Config config, Configs configs) {
        this.config = config;
        try {
            for (String dictionaryResource : configs.getStringList(config, "dictionaryResources", Collections.<String>emptyList())) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL resource = classLoader.getResource(dictionaryResource);
                Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (String)"Can not find grok dictionary resource:%s (classLoader:%s)", (Object[])new Object[]{dictionaryResource, classLoader});
                this.LOG.debug("Loading grok dictionary:{} source:classpath", (Object)dictionaryResource);
                InputStreamReader inputStreamReader = new InputStreamReader(resource.openStream());
                this.loadDictionary(inputStreamReader);
                inputStreamReader.close();
            }
            for (String dictionaryFile : configs.getStringList(config, "dictionaryFiles", Collections.EMPTY_LIST)) {
                this.LOG.debug("Loading grok dictionary:{} source:filesystem", (Object)dictionaryFile);
                this.loadDictionaryFile(new File(dictionaryFile));
            }
            String dictionaryString = configs.getString(config, "dictionaryString", "");
            if (this.LOG.isDebugEnabled() && !dictionaryString.isEmpty()) {
                this.LOG.debug("Loading inline grok dictionary:{}", (Object)dictionaryString);
            }
            this.loadDictionary(new StringReader(dictionaryString));
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot compile grok dictionary", config, e);
        }
        this.resolveDictionaryExpressions();
    }

    public Pattern compileExpression(String expr) {
        expr = this.resolveExpression(expr);
        return Pattern.compile(expr);
    }

    private Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDictionaryFile(File fileOrDir) throws IOException {
        if (!fileOrDir.exists()) {
            throw new FileNotFoundException("File not found: " + fileOrDir);
        }
        if (!fileOrDir.canRead()) {
            throw new IOException("Insufficient permissions to read file: " + fileOrDir);
        }
        if (fileOrDir.isDirectory()) {
            Object[] files = fileOrDir.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                this.loadDictionaryFile((File)file);
            }
        } else {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileOrDir), "UTF-8");
            try {
                this.loadDictionary(reader);
            }
            finally {
                Closeables.closeQuietly((Closeable)reader);
            }
        }
    }

    private void loadDictionary(Reader reader) throws IOException {
        for (String line : CharStreams.readLines((Readable)reader)) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            int i = line.indexOf(" ");
            if (i < 0) {
                throw new MorphlineCompilationException("Dictionary entry line must contain a space to separate name and value: " + line, this.getConfig());
            }
            if (i == 0) {
                throw new MorphlineCompilationException("Dictionary entry line must contain a name: " + line, this.getConfig());
            }
            String name = line.substring(0, i);
            String value = line.substring(i + 1, line.length()).trim();
            if (value.length() == 0) {
                throw new MorphlineCompilationException("Dictionary entry line must contain a value: " + line, this.getConfig());
            }
            this.dictionary.put(name, value);
        }
    }

    private void resolveDictionaryExpressions() {
        boolean wasModified = true;
        block0: while (wasModified) {
            wasModified = false;
            for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
                String resolvedExpr;
                String expr = entry.getValue();
                wasModified = expr != (resolvedExpr = this.resolveExpression(expr));
                if (!wasModified) continue;
                entry.setValue(resolvedExpr);
                continue block0;
            }
        }
        this.LOG.debug("dictionary: {}", (Object)Joiner.on((String)"\n").join(new TreeMap<String, String>(this.dictionary).entrySet()));
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            Pattern.compile(entry.getValue());
        }
    }

    private String resolveExpression(String expr) {
        int j;
        int i;
        String PATTERN_START = "%{";
        String PATTERN_END = "}";
        int SEPARATOR = 58;
        while ((i = expr.indexOf(PATTERN_START)) >= 0 && (j = expr.indexOf(PATTERN_END, i + PATTERN_START.length())) >= 0) {
            String refValue;
            String grokPattern = expr.substring(i + PATTERN_START.length(), j);
            int p = grokPattern.indexOf(SEPARATOR);
            String regexName = grokPattern;
            String groupName = null;
            String conversion = null;
            if (p >= 0) {
                regexName = grokPattern.substring(0, p);
                groupName = grokPattern.substring(p + 1, grokPattern.length());
                int q = groupName.indexOf(SEPARATOR);
                if (q >= 0) {
                    conversion = groupName.substring(q + 1, groupName.length());
                    groupName = groupName.substring(0, q);
                }
            }
            if ((refValue = this.dictionary.get(regexName)) == null) {
                throw new MorphlineCompilationException("Missing value for name: " + regexName, this.getConfig());
            }
            if (refValue.contains(PATTERN_START)) break;
            String replacement = refValue;
            if (groupName != null) {
                replacement = "(?<" + groupName + ">" + refValue + ")";
            }
            expr = new StringBuilder(expr).replace(i, j + PATTERN_END.length(), replacement).toString();
        }
        return expr;
    }
}

