/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class StringArray
extends TOP
implements StringArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private StringArray() {
    }

    public StringArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public StringArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createArray(jcas.getType((int)StringArray.typeIndexID).casTypeCode, length, true), jcas.getType(typeIndexID));
    }

    public String get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getStringArrayValue(this.addr, i);
    }

    public void set(int i, String v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setStringArrayValue(this.addr, i, v);
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setStringArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getStringArrayValue(this.addr, i + srcOffset);
        }
    }

    public String[] toArray() {
        int size = this.size();
        String[] outArray = new String[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(StringArray.class);
    }
}

