/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.admin;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CASAdminException
extends RuntimeException {
    private static final long serialVersionUID = 3968205828762300170L;
    private static final String resource_file = "org.apache.uima.cas.admin.admin_errors";
    private static final String missing_resource_error = "Could not load message catalog: org.apache.uima.cas.admin.admin_errors";
    private static final int MESSAGES_NOT_FOUND = -1;
    public static final int REPOSITORY_LOCKED = 0;
    public static final int TYPE_SYSTEM_LOCKED = 1;
    public static final int MUST_COMMIT_TYPE_SYSTEM = 2;
    public static final int MUST_COMMIT_INDEX_REPOSITORY = 3;
    public static final int BAD_TYPE_SYNTAX = 4;
    public static final int BAD_FEATURE_SYNTAX = 5;
    public static final int TYPE_IS_INH_FINAL = 6;
    public static final int TYPE_IS_FEATURE_FINAL = 7;
    public static final int DESERIALIZATION_ERROR = 8;
    public static final int FLUSH_DISABLED = 9;
    public static final int JCAS_ERROR = 10;
    public static final int DUPLICATE_FEATURE = 11;
    private static final String[] identifiers = new String[]{"REPOSITORY_LOCKED", "TYPE_SYSTEM_LOCKED", "MUST_COMMIT_TYPE_SYSTEM", "MUST_COMMIT_INDEX_REPOSITORY", "BAD_TYPE_SYNTAX", "BAD_FEATURE_SYNTAX", "TYPE_IS_INH_FINAL", "TYPE_IS_FEATURE_FINAL", "DESERIALIZATION_ERROR", "FLUSH_DISABLED", "JCAS_ERROR", "DUPLICATE_FEATURE"};
    private int error;
    private ResourceBundle resource = null;
    private String[] arguments = new String[9];

    public CASAdminException(int error) {
        this.error = error;
    }

    public int getError() {
        return this.error;
    }

    public String getMessage() {
        if (this.resource == null) {
            try {
                this.resource = ResourceBundle.getBundle(resource_file);
            }
            catch (MissingResourceException e) {
                this.error = -1;
                return missing_resource_error;
            }
        }
        return new MessageFormat(this.resource.getString(identifiers[this.error])).format(this.arguments);
    }

    public String toString() {
        return "CASAdminException: " + this.getMessage();
    }

    public boolean addArgument(String s) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = s;
            return true;
        }
        return false;
    }

    public String getMessageCode() {
        return identifiers[this.error];
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getBundleShortName() {
        if (resource_file.indexOf(46) >= 0) {
            return resource_file.substring(resource_file.lastIndexOf(46) + 1);
        }
        return resource_file;
    }
}

