/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.update;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jp.sf.fess.solr.plugin.suggest.SuggestUpdateConfig;
import jp.sf.fess.solr.plugin.suggest.SuggestUpdateController;
import jp.sf.fess.solr.plugin.suggest.entity.SuggestFieldInfo;
import jp.sf.fess.solr.plugin.suggest.util.SolrConfigUtil;
import jp.sf.fess.solr.plugin.suggest.util.TransactionLogUtil;
import jp.sf.fess.solr.plugin.update.FessUpdateHandler;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilter;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilterChain;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTranslogUpdateHandlerFilter
extends UpdateHandlerFilter {
    private static final Logger logger = LoggerFactory.getLogger(SuggestTranslogUpdateHandlerFilter.class);
    private SuggestUpdateController suggestUpdateController;

    @Override
    public void setFessUpdateHandler(FessUpdateHandler updateHandler) {
        super.setFessUpdateHandler(updateHandler);
        this.startup();
    }

    protected void startup() {
        SolrCore core = this.updateHandler.getSolrCore();
        UpdateLog ulog = this.updateHandler.getUpdateLog();
        TransactionLogUtil.clearSuggestTransactionLog(ulog.getLogDir());
        SuggestUpdateConfig config = SolrConfigUtil.getUpdateHandlerConfig(core.getSolrConfig());
        List<SuggestFieldInfo> suggestFieldInfoList = SolrConfigUtil.getSuggestFieldInfoList(config);
        this.suggestUpdateController = new SuggestUpdateController(config, suggestFieldInfoList);
        if (config.getLabelFields() != null) {
            for (String label : config.getLabelFields()) {
                this.suggestUpdateController.addLabelFieldName(label);
            }
        }
        if (config.getRoleFields() != null) {
            for (String role : config.getRoleFields()) {
                this.suggestUpdateController.addRoleFieldName(role);
            }
        }
        this.suggestUpdateController.setLimitDocumentQueuingNum(2);
        this.suggestUpdateController.start();
    }

    @Override
    public void commit(CommitUpdateCommand cmd, UpdateHandlerFilterChain chain) throws IOException {
        UpdateLog ulog = this.updateHandler.getUpdateLog();
        File logDir = new File(ulog.getLogDir());
        long lastLogId = ulog.getLastLogId();
        String lastLogName = String.format(Locale.ROOT, UpdateLog.LOG_FILENAME_PATTERN, UpdateLog.TLOG_NAME, lastLogId);
        chain.commit(cmd);
        File logFile = new File(logDir, lastLogName);
        if (logFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("Create " + logFile.getAbsolutePath());
            }
            this.suggestUpdateController.addTransactionLog(logFile);
        } else if (logger.isInfoEnabled()) {
            logger.info(logFile.getName() + " does not exist.");
        }
    }

    @Override
    public void close(UpdateHandlerFilterChain chain) throws IOException {
        chain.close();
        this.suggestUpdateController.close();
    }
}

