/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.update;

import java.io.IOException;
import java.util.ArrayList;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilter;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilterChain;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FessUpdateHandler
extends DirectUpdateHandler2 {
    protected UpdateHandlerFilter[] filters;

    public FessUpdateHandler(SolrCore core) {
        super(core);
        this.loadFilters();
    }

    public FessUpdateHandler(SolrCore core, UpdateHandler updateHandler) {
        super(core, updateHandler);
        this.loadFilters();
    }

    public SolrCore getSolrCore() {
        return this.core;
    }

    protected void loadFilters() {
        SolrConfig solrConfig = this.core.getSolrConfig();
        NodeList filterNodeList = solrConfig.getNodeList("updateHandler/filters/filter", false);
        if (filterNodeList == null) {
            log.info("No UpdateHandlerFilter.");
            this.filters = new UpdateHandlerFilter[0];
        } else {
            ArrayList<UpdateHandlerFilter> filterList = new ArrayList<UpdateHandlerFilter>();
            for (int i = 0; i < filterNodeList.getLength(); ++i) {
                Node filterItem = filterNodeList.item(i);
                String nodeName = filterItem.getNodeName();
                if (!"filter".equals(nodeName)) continue;
                Node classItem = filterItem.getAttributes().getNamedItem("class");
                String className = classItem.getNodeValue();
                try {
                    Class<?> clazz = Class.forName(className);
                    UpdateHandlerFilter filter = (UpdateHandlerFilter)clazz.newInstance();
                    filter.setFessUpdateHandler(this);
                    log.info("Load " + className);
                    filterList.add(filter);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not load " + className, e);
                }
            }
            this.filters = filterList.toArray(new UpdateHandlerFilter[filterList.size()]);
        }
    }

    public int addDoc(AddUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        return chain.addDoc(cmd);
    }

    protected int doAddDoc(AddUpdateCommand cmd) throws IOException {
        return super.addDoc(cmd);
    }

    public void delete(DeleteUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.delete(cmd);
    }

    protected void doDelete(DeleteUpdateCommand cmd) throws IOException {
        super.delete(cmd);
    }

    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.deleteByQuery(cmd);
    }

    protected void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        super.deleteByQuery(cmd);
    }

    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        return chain.mergeIndexes(cmd);
    }

    protected int doMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        return super.mergeIndexes(cmd);
    }

    public void prepareCommit(CommitUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.prepareCommit(cmd);
    }

    protected void doPrepareCommit(CommitUpdateCommand cmd) throws IOException {
        super.prepareCommit(cmd);
    }

    public void commit(CommitUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.commit(cmd);
    }

    protected void doCommit(CommitUpdateCommand cmd) throws IOException {
        super.commit(cmd);
    }

    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.rollback(cmd);
    }

    protected void doRollback(RollbackUpdateCommand cmd) throws IOException {
        super.rollback(cmd);
    }

    public void split(SplitIndexCommand cmd) throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.split(cmd);
    }

    protected void doSplit(SplitIndexCommand cmd) throws IOException {
        super.split(cmd);
    }

    public void close() throws IOException {
        UpdateHandlerFilterChain chain = new UpdateHandlerFilterChain(this, this.filters);
        chain.close();
    }

    protected void doClose() throws IOException {
        super.close();
    }
}

