/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.solr.update.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLogUtil.class);
    private static final String PREFIX = "suggest-";
    private static volatile Constructor<TransactionLog> transactionLogConstructor;

    private TransactionLogUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionLog createSuggestTransactionLog(File tlogFile, Collection<String> globalStrings, boolean openExisting) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, InvocationTargetException {
        long start = System.currentTimeMillis();
        File file = new File(tlogFile.getParent(), PREFIX + tlogFile.getName());
        Files.copy((File)tlogFile, (File)file);
        if (logger.isInfoEnabled()) {
            logger.info("Create suggest trans log. took=" + (System.currentTimeMillis() - start) + " file=" + file.getAbsolutePath());
        }
        if (transactionLogConstructor != null) return transactionLogConstructor.newInstance(file, globalStrings, openExisting);
        Class<TransactionLogUtil> clazz = TransactionLogUtil.class;
        synchronized (TransactionLogUtil.class) {
            if (transactionLogConstructor != null) return transactionLogConstructor.newInstance(file, globalStrings, openExisting);
            Class<TransactionLog> cls = TransactionLog.class;
            transactionLogConstructor = cls.getDeclaredConstructor(File.class, Collection.class, Boolean.TYPE);
            transactionLogConstructor.setAccessible(true);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return transactionLogConstructor.newInstance(file, globalStrings, openExisting);
        }
    }

    public static void clearSuggestTransactionLog(String dir) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            return;
        }
        for (File f : d.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith(PREFIX) || f.delete()) continue;
            logger.warn("Failed to delete " + f.getAbsolutePath());
        }
    }
}

