/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;

public class SuggestItem {
    private volatile String text;
    private final List<String> readingList = Collections.synchronizedList(new ArrayList());
    private final List<String> fieldNameList = Collections.synchronizedList(new ArrayList());
    private final List<String> labels = Collections.synchronizedList(new ArrayList());
    private final List<String> roles = Collections.synchronizedList(new ArrayList());
    private volatile long count = 1L;
    private volatile String expires;
    private volatile String expiresField;
    private volatile String segment;
    private volatile String segmentField;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getReadingList() {
        return this.readingList;
    }

    public void addReading(String reading) {
        this.readingList.add(reading);
    }

    public List<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public void addFieldName(String fieldName) {
        this.fieldNameList.add(fieldName);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels.clear();
        for (String label : labels) {
            this.labels.add(label);
        }
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles.clear();
        for (String label : roles) {
            this.roles.add(label);
        }
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public String getExpiresField() {
        return this.expiresField;
    }

    public void setExpiresField(String expiresField) {
        this.expiresField = expiresField;
    }

    public String getSegment() {
        return this.segment;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public String getSegmentField() {
        return this.segmentField;
    }

    public void setSegmentField(String segmentField) {
        this.segmentField = segmentField;
    }

    public boolean equals(Object o) {
        if (o instanceof SuggestItem) {
            SuggestItem item = (SuggestItem)o;
            if (this.getDocumentId().equals(item.getDocumentId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDocumentId().hashCode();
    }

    public SolrInputDocument toSolrInputDocument() {
        SolrInputDocument doc = new SolrInputDocument();
        doc.setField("text_s", (Object)this.text);
        for (String reading : this.readingList) {
            doc.addField("reading_s_m", (Object)reading);
        }
        for (String fieldName : this.fieldNameList) {
            doc.addField("fieldname_s_m", (Object)fieldName);
        }
        doc.setField("count_i", (Object)this.count);
        doc.setField(this.expiresField, (Object)this.expires);
        doc.setField(this.segmentField, (Object)this.segment);
        for (String label : this.labels) {
            doc.addField("label_s_m", (Object)label);
        }
        for (String role : this.roles) {
            doc.addField("role_s_m", (Object)role);
        }
        doc.addField("id", (Object)this.getDocumentId());
        return doc;
    }

    public String getDocumentId() {
        return this.text;
    }

    public String toString() {
        return "SuggestItem [text=" + this.text + ", readingList=" + this.readingList + ", fieldNameList=" + this.fieldNameList + ", labels=" + this.labels + ", roles=" + this.roles + ", count=" + this.count + ", expires=" + this.expires + ", expiresField=" + this.expiresField + ", segment=" + this.segment + ", segmentField=" + this.segmentField + "]";
    }
}

