/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;

public class DocValuesComponent
extends SearchComponent {
    private static final String DCF = "dcf";
    private static final String DOC_VALUES = "docValues";

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public void process(ResponseBuilder rb) throws IOException {
        DocListAndSet results = rb.getResults();
        if (results != null) {
            SolrQueryRequest req = rb.req;
            SolrParams params = req.getParams();
            String[] docValuesFields = params.getParams(DCF);
            if (docValuesFields == null) {
                return;
            }
            DocList docs = results.docList;
            SimpleOrderedMap fragments = new SimpleOrderedMap();
            AtomicReader reader = req.getSearcher().getAtomicReader();
            for (String field : docValuesFields) {
                NumericDocValues numericDocValues = reader.getNumericDocValues(field);
                if (numericDocValues == null) continue;
                ArrayList<Long> valueList = new ArrayList<Long>();
                DocIterator iterator = docs.iterator();
                for (int i = 0; i < docs.size(); ++i) {
                    int docId = iterator.nextDoc();
                    long value = numericDocValues.get(docId);
                    valueList.add(value);
                }
                fragments.add(field, valueList);
            }
            if (fragments.size() != 0) {
                rb.rsp.add(DOC_VALUES, (Object)fragments);
            }
        }
    }

    public String getDescription() {
        return "DocValues";
    }

    public String getSource() {
        return "https://raw2.github.com/codelibs/fess-solr-plugin/master/src/main/java/jp/sf/fess/solr/plugin/search/WordFreqValueSourceParser.java";
    }
}

