/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis.monitor;

public class MonitoringTask {
    private static final boolean VERBOSE = false;
    protected Target target;
    protected long interval;
    protected volatile long lastChecked;
    protected long lastModified;
    protected Callback callback;
    public static final int DEFAULT_PERIOD = 60000;

    public MonitoringTask(Target target, long interval, Callback callback) {
        this.target = target;
        this.interval = interval;
        this.callback = callback;
        this.lastModified = target.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked < this.interval) {
            return;
        }
        MonitoringTask monitoringTask = this;
        synchronized (monitoringTask) {
            if (now - this.lastChecked < this.interval) {
                return;
            }
            this.lastChecked = now;
            long currentLastModified = this.target.lastModified();
            try {
                if (currentLastModified > this.lastModified) {
                    this.lastModified = currentLastModified;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MonitoringTask.this.callback.process();
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static interface Target {
        public long lastModified();
    }

    public static interface Callback {
        public void process();
    }
}

