/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.IO;

public class ODLparser {
    private static Logger log = LoggerFactory.getLogger(ODLparser.class);
    private Document doc;
    private boolean debug = false;
    private boolean showRaw = false;
    private boolean show = false;

    void showDoc(OutputStream out) {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        try {
            fmt.output(this.doc, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void parseFile(String filename) throws IOException {
        String text = new String(IO.readFileToByteArray(filename));
        this.parseFromString(text);
    }

    public Element parseFromString(String text) throws IOException {
        if (this.showRaw) {
            System.out.println("Raw ODL=\n" + text);
        }
        Element rootElem = new Element("odl");
        this.doc = new Document(rootElem);
        Element current = rootElem;
        StringTokenizer lineFinder = new StringTokenizer(text, "\t\n\r\f");
        while (lineFinder.hasMoreTokens()) {
            String line = lineFinder.nextToken();
            if (line.startsWith("GROUP")) {
                current = this.startGroup(current, line);
                continue;
            }
            if (line.startsWith("OBJECT")) {
                current = this.startObject(current, line);
                continue;
            }
            if (line.startsWith("END_OBJECT")) {
                this.endObject(current, line);
                current = current.getParentElement();
                continue;
            }
            if (line.startsWith("END_GROUP")) {
                this.endGroup(current, line);
                current = current.getParentElement();
                continue;
            }
            this.addField(current, line);
        }
        if (this.show) {
            this.showDoc(System.out);
        }
        return rootElem;
    }

    Element startGroup(Element parent, String line) throws IOException {
        StringTokenizer stoke = new StringTokenizer(line, "=");
        String toke = stoke.nextToken();
        assert (toke.equals("GROUP"));
        String name = stoke.nextToken();
        Element group = new Element(name);
        parent.addContent((Content)group);
        return group;
    }

    void endGroup(Element current, String line) throws IOException {
        StringTokenizer stoke = new StringTokenizer(line, "=");
        String toke = stoke.nextToken();
        assert (toke.equals("END_GROUP"));
        String name = stoke.nextToken();
        if (this.debug) {
            System.out.println(line + " -> " + current);
        }
        assert (name.equals(current.getName()));
    }

    Element startObject(Element parent, String line) throws IOException {
        StringTokenizer stoke = new StringTokenizer(line, "=");
        String toke = stoke.nextToken();
        assert (toke.equals("OBJECT"));
        String name = stoke.nextToken();
        Element obj = new Element(name);
        parent.addContent((Content)obj);
        return obj;
    }

    void endObject(Element current, String line) throws IOException {
        StringTokenizer stoke = new StringTokenizer(line, "=");
        String toke = stoke.nextToken();
        assert (toke.equals("END_OBJECT"));
        String name = stoke.nextToken();
        if (this.debug) {
            System.out.println(line + " -> " + current);
        }
        assert (name.equals(current.getName())) : name + " !+ " + current.getName();
    }

    void addField(Element parent, String line) throws IOException {
        StringTokenizer stoke = new StringTokenizer(line, "=");
        String name = stoke.nextToken();
        if (stoke.hasMoreTokens()) {
            Element field = new Element(name);
            parent.addContent((Content)field);
            String value = stoke.nextToken();
            if (value.startsWith("(")) {
                this.parseValueCollection(field, value);
                return;
            }
            value = this.stripQuotes(value);
            field.addContent(value);
        }
    }

    void parseValueCollection(Element field, String value) {
        if (value.startsWith("(")) {
            value = value.substring(1);
        }
        if (value.endsWith(")")) {
            value = value.substring(0, value.length() - 1);
        }
        StringTokenizer stoke = new StringTokenizer(value, "\",");
        while (stoke.hasMoreTokens()) {
            field.addContent((Content)new Element("value").addContent(this.stripQuotes(stoke.nextToken())));
        }
    }

    String stripQuotes(String name) {
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void main(String[] args) throws IOException {
        ODLparser p = new ODLparser();
        p.parseFile("c:/temp/odl.struct.txt");
    }
}

