/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.seasar.robot.helper.MemoryDataHelper;
import org.seasar.robot.service.UrlFilterService;

public class UrlFilterServiceImpl
implements UrlFilterService {
    @Resource
    protected MemoryDataHelper dataHelper;

    @Override
    public void addIncludeUrlFilter(String sessionId, String url) {
        this.dataHelper.addIncludeUrlPattern(sessionId, url);
    }

    @Override
    public void addIncludeUrlFilter(String sessionId, List<String> urlList) {
        for (String url : urlList) {
            this.dataHelper.addIncludeUrlPattern(sessionId, url);
        }
    }

    @Override
    public void addExcludeUrlFilter(String sessionId, String url) {
        this.dataHelper.addExcludeUrlPattern(sessionId, url);
    }

    @Override
    public void addExcludeUrlFilter(String sessionId, List<String> urlList) {
        for (String url : urlList) {
            this.dataHelper.addExcludeUrlPattern(sessionId, url);
        }
    }

    @Override
    public void delete(String sessionId) {
        this.dataHelper.clearUrlPattern(sessionId);
    }

    @Override
    public void deleteAll() {
        this.dataHelper.clearUrlPattern();
    }

    @Override
    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        return this.dataHelper.getIncludeUrlPatternList(sessionId);
    }

    @Override
    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        return this.dataHelper.getExcludeUrlPatternList(sessionId);
    }
}

