/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.synthetic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.NotBlank;

@Bindable(prefix="ByAttributeClusteringAlgorithm", inherit={CommonAttributes.class})
@Label(value="By Attribute Clustering")
public class ByFieldClusteringAlgorithm
extends ProcessingComponentBase
implements IClusteringAlgorithm {
    @Processing
    @Input
    @Internal
    @Attribute(key="documents", inherit=true)
    public List<Document> documents;
    @Processing
    @Output
    @Internal
    @Attribute(key="clusters", inherit=true)
    public List<Cluster> clusters = null;
    @Processing
    @Input
    @Attribute
    @Required
    @NotBlank
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Fields")
    @Label(value="Field name")
    public String fieldName = "sources";

    @Override
    public void process() throws ProcessingException {
        HashMap clusterMap = Maps.newHashMap();
        for (Document document : this.documents) {
            Object field = document.getField(this.fieldName);
            if (field instanceof Collection) {
                for (Object value : (Collection)field) {
                    this.addToCluster(clusterMap, value, document);
                }
                continue;
            }
            this.addToCluster(clusterMap, field, document);
        }
        this.clusters = Lists.newArrayList(clusterMap.values());
        Collections.sort(this.clusters, Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR);
        Cluster.appendOtherTopics(this.documents, this.clusters);
    }

    private void addToCluster(Map<Object, Cluster> clusters, Object fieldValue, Document document) {
        if (fieldValue == null) {
            return;
        }
        Cluster cluster = clusters.get(fieldValue);
        if (cluster == null) {
            cluster = new Cluster();
            cluster.addPhrases(this.buildClusterLabel(fieldValue));
            clusters.put(fieldValue, cluster);
        }
        cluster.addDocuments(document);
    }

    protected String buildClusterLabel(Object fieldValue) {
        return fieldValue.toString();
    }
}

