/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class ClusterManagerBase
extends ManagerBase
implements ClusterManager {
    private final Log log = LogFactory.getLog(ClusterManagerBase.class);
    protected CatalinaCluster cluster = null;
    private boolean notifyListenersOnReplication = true;
    private String sessionAttributeFilter = null;
    private Pattern sessionAttributePattern = null;
    private volatile ReplicationValve replicationValve = null;

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    public String getSessionAttributeFilter() {
        return this.sessionAttributeFilter;
    }

    public void setSessionAttributeFilter(String sessionAttributeFilter) {
        if (sessionAttributeFilter == null || sessionAttributeFilter.trim().equals("")) {
            this.sessionAttributeFilter = null;
            this.sessionAttributePattern = null;
        } else {
            this.sessionAttributeFilter = sessionAttributeFilter;
            this.sessionAttributePattern = Pattern.compile(sessionAttributeFilter);
        }
    }

    public boolean willAttributeDistribute(String name) {
        if (this.sessionAttributePattern == null) {
            return true;
        }
        return this.sessionAttributePattern.matcher(name).matches();
    }

    public static ClassLoader[] getClassLoaders(Container container) {
        Loader loader = null;
        ClassLoader classLoader = null;
        if (container != null) {
            loader = container.getLoader();
        }
        if ((classLoader = loader != null ? loader.getClassLoader() : Thread.currentThread().getContextClassLoader()) == Thread.currentThread().getContextClassLoader()) {
            return new ClassLoader[]{classLoader};
        }
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader()};
    }

    public ClassLoader[] getClassLoaders() {
        return ClusterManagerBase.getClassLoaders(this.container);
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] data) throws IOException {
        return this.getReplicationStream(data, 0, data.length);
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] data, int offset, int length) throws IOException {
        ByteArrayInputStream fis = new ByteArrayInputStream(data, offset, length);
        return new ReplicationStream((InputStream)fis, this.getClassLoaders());
    }

    public void load() {
    }

    public void unload() {
    }

    protected void clone(ClusterManagerBase copy) {
        copy.setName("Clone-from-" + this.getName());
        copy.setMaxActiveSessions(this.getMaxActiveSessions());
        copy.setMaxInactiveInterval(this.getMaxInactiveInterval());
        copy.setSessionIdLength(this.getSessionIdLength());
        copy.setProcessExpiresFrequency(this.getProcessExpiresFrequency());
        copy.setNotifyListenersOnReplication(this.isNotifyListenersOnReplication());
        copy.setSessionAttributeFilter(this.getSessionAttributeFilter());
        copy.setSecureRandomClass(this.getSecureRandomClass());
        copy.setSecureRandomProvider(this.getSecureRandomProvider());
        copy.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
    }

    protected void registerSessionAtReplicationValve(DeltaSession session) {
        Valve[] valves;
        CatalinaCluster cluster;
        if (this.replicationValve == null && (cluster = this.getCluster()) != null && (valves = cluster.getValves()) != null && valves.length > 0) {
            for (int i = 0; this.replicationValve == null && i < valves.length; ++i) {
                if (!(valves[i] instanceof ReplicationValve)) continue;
                this.replicationValve = (ReplicationValve)valves[i];
            }
            if (this.replicationValve == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"no ReplicationValve found for CrossContext Support");
            }
        }
        if (this.replicationValve != null) {
            this.replicationValve.registerReplicationSession(session);
        }
    }

    protected void startInternal() throws LifecycleException {
        Cluster cluster;
        super.startInternal();
        if (this.getCluster() == null && (cluster = this.getContainer().getCluster()) instanceof CatalinaCluster) {
            this.setCluster((CatalinaCluster)cluster);
        }
        if (this.cluster != null) {
            this.cluster.registerManager(this);
        }
    }

    protected void stopInternal() throws LifecycleException {
        if (this.cluster != null) {
            this.cluster.removeManager(this);
        }
        this.replicationValve = null;
        super.stopInternal();
    }
}

