/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.seasar.extension.jta.ExtendedTransaction;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SNotSupportedException;
import org.seasar.framework.util.TransactionUtil;

public abstract class AbstractTransactionManagerImpl
implements TransactionManager {
    protected final ThreadLocal threadAttachTx = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            throw new SNotSupportedException("ESSR0316", null);
        }
        tx = this.attachNewTransaction();
        tx.begin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.commit();
        }
        finally {
            this.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction suspend() throws SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.suspend();
        }
        finally {
            this.setCurrent(null);
        }
        return tx;
    }

    public void resume(Transaction resumeTx) throws InvalidTransactionException, IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        ((ExtendedTransaction)resumeTx).resume();
        this.setCurrent((ExtendedTransaction)resumeTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.rollback();
        }
        finally {
            this.setCurrent(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }

    public int getStatus() {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            return TransactionUtil.getStatus((Transaction)tx);
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.getCurrent();
    }

    protected ExtendedTransaction getCurrent() {
        ExtendedTransaction tx = (ExtendedTransaction)this.threadAttachTx.get();
        if (tx != null && TransactionUtil.getStatus((Transaction)tx) == 6) {
            this.setCurrent(null);
            return null;
        }
        return tx;
    }

    protected void setCurrent(ExtendedTransaction current) {
        this.threadAttachTx.set(current);
    }

    protected ExtendedTransaction attachNewTransaction() {
        ExtendedTransaction tx = (ExtendedTransaction)this.threadAttachTx.get();
        if (tx == null) {
            tx = this.createTransaction();
            this.setCurrent(tx);
        }
        return tx;
    }

    protected abstract ExtendedTransaction createTransaction();
}

