/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.MP3Frame;

public class ID3v2Frame
implements MP3Frame {
    private int majorVersion;
    private int minorVersion;
    private int flags;
    private int length;
    private byte[] extendedHeader;
    private byte[] data;
    protected static final TextEncoding[] encodings = new TextEncoding[]{new TextEncoding("ISO-8859-1", false), new TextEncoding("UTF-16", true), new TextEncoding("UTF-16BE", true), new TextEncoding("UTF-8", false)};

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getExtendedHeader() {
        return this.extendedHeader;
    }

    public byte[] getData() {
        return this.data;
    }

    public static MP3Frame createFrameIfPresent(InputStream inp) throws IOException {
        int h1 = inp.read();
        int h2 = inp.read();
        int h3 = inp.read();
        if (h1 == 73 && h2 == 68 && h3 == 51) {
            int majorVersion = inp.read();
            int minorVersion = inp.read();
            if (majorVersion == -1 || minorVersion == -1) {
                ID3v2Frame.pushBack(inp, h1, h2, h3, majorVersion, minorVersion);
                return null;
            }
            return new ID3v2Frame(majorVersion, minorVersion, inp);
        }
        ID3v2Frame.pushBack(inp, h1, h2, h3);
        return null;
    }

    private static void pushBack(InputStream inp, int ... bytes) throws IOException {
        if (inp instanceof PushbackInputStream) {
            byte[] buf = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                buf[i] = (byte)bytes[i];
            }
            ((PushbackInputStream)inp).unread(buf);
        }
    }

    private ID3v2Frame(int majorVersion, int minorVersion, InputStream inp) throws IOException {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.flags = inp.read();
        this.length = ID3v2Frame.get7BitsInt(ID3v2Frame.readFully(inp, 4), 0);
        if ((this.flags & 2) == 2) {
            int size = ID3v2Frame.getInt(ID3v2Frame.readFully(inp, 4));
            this.extendedHeader = ID3v2Frame.readFully(inp, size);
        }
        this.data = ID3v2Frame.readFully(inp, this.length, false);
    }

    protected static int getInt(byte[] data) {
        return ID3v2Frame.getInt(data, 0);
    }

    protected static int getInt(byte[] data, int offset) {
        int b0 = data[offset + 0] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        int b2 = data[offset + 2] & 0xFF;
        int b3 = data[offset + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    protected static int getInt3(byte[] data, int offset) {
        int b0 = data[offset + 0] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        int b2 = data[offset + 2] & 0xFF;
        return (b0 << 16) + (b1 << 8) + (b2 << 0);
    }

    protected static int getInt2(byte[] data, int offset) {
        int b0 = data[offset + 0] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return (b0 << 8) + (b1 << 0);
    }

    protected static int get7BitsInt(byte[] data, int offset) {
        int b0 = data[offset + 0] & 0x7F;
        int b1 = data[offset + 1] & 0x7F;
        int b2 = data[offset + 2] & 0x7F;
        int b3 = data[offset + 3] & 0x7F;
        return (b0 << 21) + (b1 << 14) + (b2 << 7) + (b3 << 0);
    }

    protected static byte[] readFully(InputStream inp, int length) throws IOException {
        return ID3v2Frame.readFully(inp, length, true);
    }

    protected static byte[] readFully(InputStream inp, int length, boolean shortDataIsFatal) throws IOException {
        int read;
        byte[] b = new byte[length];
        for (int pos = 0; pos < length; pos += read) {
            read = inp.read(b, pos, length - pos);
            if (read != -1) continue;
            if (shortDataIsFatal) {
                throw new IOException("Tried to read " + length + " bytes, but only " + pos + " bytes present");
            }
            return b;
        }
        return b;
    }

    protected static String getTagString(byte[] data, int offset, int length) {
        int actualLength = length;
        if (actualLength == 0) {
            return "";
        }
        if (actualLength == 1 && data[offset] == 0) {
            return "";
        }
        TextEncoding encoding = encodings[0];
        byte maybeEncodingFlag = data[offset];
        if (maybeEncodingFlag >= 0 && maybeEncodingFlag < encodings.length) {
            ++offset;
            --actualLength;
            encoding = encodings[maybeEncodingFlag];
        }
        while (encoding.doubleByte && actualLength >= 2 && data[offset + actualLength - 1] == 0 && data[offset + actualLength - 2] == 0) {
            actualLength -= 2;
        }
        while (!encoding.doubleByte && actualLength >= 1 && data[offset + actualLength - 1] == 0) {
            --actualLength;
        }
        if (actualLength == 0) {
            return "";
        }
        if (encoding.encoding.equals("UTF-16") && actualLength == 2 && (data[offset] == -1 && data[offset + 1] == -2 || data[offset] == -2 && data[offset + 1] == -1)) {
            return "";
        }
        try {
            return new String(data, offset, actualLength, encoding.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding " + encoding.encoding + " is not available", e);
        }
    }

    protected static ID3Tags.ID3Comment getComment(byte[] data, int offset, int length) {
        byte encodingFlag = data[offset];
        if (encodingFlag < 0 || encodingFlag >= encodings.length) {
            return null;
        }
        TextEncoding encoding = encodings[encodingFlag];
        String lang = ID3v2Frame.getString(data, offset + 1, 3);
        int descStart = offset + 4;
        int textStart = -1;
        String description = null;
        String text = null;
        try {
            for (int i = descStart; i < offset + length; ++i) {
                if (encoding.doubleByte && data[i] == 0 && data[i + 1] == 0) {
                    if (i + 2 < offset + length && data[i + 1] == 0 && data[i + 2] == 0) {
                        ++i;
                    }
                    textStart = i + 2;
                    description = new String(data, descStart, i - descStart, encoding.encoding);
                    break;
                }
                if (encoding.doubleByte || data[i] != 0) continue;
                textStart = i + 1;
                description = new String(data, descStart, i - descStart, encoding.encoding);
                break;
            }
            text = textStart > -1 ? new String(data, textStart, offset + length - textStart, encoding.encoding) : new String(data, descStart, offset + length - descStart, encoding.encoding);
            return new ID3Tags.ID3Comment(lang, description, text);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding " + encoding.encoding + " is not available", e);
        }
    }

    protected static String getString(byte[] data, int offset, int length) {
        try {
            return new String(data, offset, length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding ISO-8859-1 encoding is not available", e);
        }
    }

    protected static class RawTag {
        private int headerSize;
        protected String name;
        protected int flag;
        protected byte[] data;

        private RawTag(int nameLength, int sizeLength, int sizeMultiplier, int flagLength, byte[] frameData, int offset) {
            this.headerSize = nameLength + sizeLength + flagLength;
            this.name = ID3v2Frame.getString(frameData, offset, nameLength);
            int rawSize = sizeLength == 3 ? ID3v2Frame.getInt3(frameData, offset + nameLength) : ID3v2Frame.getInt(frameData, offset + nameLength);
            int size = rawSize * sizeMultiplier;
            if (flagLength > 0) {
                this.flag = flagLength == 1 ? frameData[offset + nameLength + sizeLength] : ID3v2Frame.getInt2(frameData, offset + nameLength + sizeLength);
            }
            int copyFrom = offset + nameLength + sizeLength + flagLength;
            size = Math.min(size, frameData.length - copyFrom);
            this.data = new byte[size];
            System.arraycopy(frameData, copyFrom, this.data, 0, size);
        }

        protected int getSize() {
            return this.headerSize + this.data.length;
        }
    }

    protected class RawTagIterator
    implements Iterator<RawTag> {
        private int nameLength;
        private int sizeLength;
        private int sizeMultiplier;
        private int flagLength;
        private int offset = 0;

        protected RawTagIterator(int nameLength, int sizeLength, int sizeMultiplier, int flagLength) {
            this.nameLength = nameLength;
            this.sizeLength = sizeLength;
            this.sizeMultiplier = sizeMultiplier;
            this.flagLength = flagLength;
        }

        @Override
        public boolean hasNext() {
            return this.offset < ID3v2Frame.this.data.length && ID3v2Frame.this.data[this.offset] != 0;
        }

        @Override
        public RawTag next() {
            RawTag tag = new RawTag(this.nameLength, this.sizeLength, this.sizeMultiplier, this.flagLength, ID3v2Frame.this.data, this.offset);
            this.offset += tag.getSize();
            return tag;
        }

        @Override
        public void remove() {
        }
    }

    protected static class TextEncoding {
        public final boolean doubleByte;
        public final String encoding;

        private TextEncoding(String encoding, boolean doubleByte) {
            this.doubleByte = doubleByte;
            this.encoding = encoding;
        }
    }
}

