/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.context.impl;

import java.util.List;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.util.DfCollectionUtil;

public class CommandContextImpl
implements CommandContext {
    private final StringKeyMap<Object> _args = StringKeyMap.createAsCaseInsensitive();
    private final StringKeyMap<Class<?>> _argTypes = StringKeyMap.createAsCaseInsensitive();
    private final StringBuilder _sqlSb = new StringBuilder(100);
    private final List<Object> _bindVariables = DfCollectionUtil.newArrayList();
    private final List<Class<?>> _bindVariableTypes = DfCollectionUtil.newArrayList();
    private final CommandContext _parent;
    private boolean _enabled;
    private boolean _beginChild;
    private boolean _alreadySkippedConnector;

    private CommandContextImpl() {
        this._parent = null;
        this._enabled = true;
    }

    private CommandContextImpl(CommandContext parent) {
        this._parent = parent;
        this._enabled = false;
    }

    public static CommandContextImpl createCommandContextImplAsRoot() {
        return new CommandContextImpl();
    }

    public static CommandContextImpl createCommandContextImplAsBeginChild(CommandContext parent) {
        return new CommandContextImpl(parent).asBeginChild();
    }

    private CommandContextImpl asBeginChild() {
        this._beginChild = true;
        return this;
    }

    @Override
    public Object getArg(String name) {
        if (this._args.containsKey(name)) {
            return this._args.get(name);
        }
        if (this._parent != null) {
            return this._parent.getArg(name);
        }
        if (this._args.size() == 1) {
            String firstKey = this._args.keySet().iterator().next();
            return this._args.get(firstKey);
        }
        return null;
    }

    @Override
    public Class<?> getArgType(String name) {
        if (this._argTypes.containsKey(name)) {
            return this._argTypes.get(name);
        }
        if (this._parent != null) {
            return this._parent.getArgType(name);
        }
        if (this._argTypes.size() == 1) {
            String firstKey = this._argTypes.keySet().iterator().next();
            return this._argTypes.get(firstKey);
        }
        return null;
    }

    @Override
    public void addArg(String name, Object arg, Class<?> argType) {
        this._args.put(name, arg);
        this._argTypes.put(name, argType);
    }

    @Override
    public String getSql() {
        return this._sqlSb.toString();
    }

    @Override
    public Object[] getBindVariables() {
        return this._bindVariables.toArray(new Object[this._bindVariables.size()]);
    }

    @Override
    public Class<?>[] getBindVariableTypes() {
        return this._bindVariableTypes.toArray(new Class[this._bindVariableTypes.size()]);
    }

    @Override
    public CommandContext addSql(String sql) {
        this._sqlSb.append(sql);
        return this;
    }

    @Override
    public CommandContext addSql(String sql, Object bindVariable, Class<?> bindVariableType) {
        this._sqlSb.append(sql);
        this._bindVariables.add(bindVariable);
        this._bindVariableTypes.add(bindVariableType);
        return this;
    }

    @Override
    public CommandContext addSql(String sql, Object[] bindVariables, Class<?>[] bindVariableTypes) {
        this._sqlSb.append(sql);
        for (int i = 0; i < bindVariables.length; ++i) {
            this._bindVariables.add(bindVariables[i]);
            this._bindVariableTypes.add(bindVariableTypes[i]);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append((CharSequence)this._sqlSb).append(", ");
        sb.append(this._enabled).append(", ");
        sb.append(this._beginChild).append(", ");
        sb.append(this._alreadySkippedConnector).append(", ");
        sb.append("parent=").append(this._parent);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public boolean isBeginChild() {
        return this._beginChild;
    }

    @Override
    public boolean isAlreadySkippedConnector() {
        return this._alreadySkippedConnector;
    }

    @Override
    public void setAlreadySkippedConnector(boolean alreadySkippedConnector) {
        this._alreadySkippedConnector = alreadySkippedConnector;
    }
}

