/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.seasar.dbflute.jdbc.MetaDataConnectionProvider;

public class LazyDatabaseMetaDataWrapper
implements DatabaseMetaData {
    protected final MetaDataConnectionProvider _connectionProvider;
    protected Connection _lazyConnection;
    protected DatabaseMetaData _lazyMetaData;
    protected boolean _restrictedMetaData;

    public LazyDatabaseMetaDataWrapper(MetaDataConnectionProvider connectionProvider) {
        this._connectionProvider = connectionProvider;
    }

    protected DatabaseMetaData getActualMetaData() throws SQLException {
        if (this._restrictedMetaData) {
            String msg = "The meta data is restriected.";
            throw new IllegalStateException(msg);
        }
        if (this._lazyMetaData != null) {
            return this._lazyMetaData;
        }
        this._lazyConnection = this._connectionProvider.getConnection();
        this._lazyMetaData = this._lazyConnection.getMetaData();
        return this._lazyMetaData;
    }

    public void restrictMetaData() {
        this._restrictedMetaData = true;
    }

    public void closeActualReally() throws SQLException {
        if (this._lazyConnection != null) {
            this._lazyConnection.close();
            this._lazyConnection = null;
        }
        this._lazyMetaData = null;
    }

    @Override
    public <T> T unwrap(Class<T> class1) throws SQLException {
        return this.getActualMetaData().unwrap(class1);
    }

    @Override
    public boolean isWrapperFor(Class<?> class1) throws SQLException {
        return this.getActualMetaData().isWrapperFor(class1);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.getActualMetaData().allProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.getActualMetaData().allTablesAreSelectable();
    }

    @Override
    public String getURL() throws SQLException {
        return this.getActualMetaData().getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.getActualMetaData().getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getActualMetaData().isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getActualMetaData().nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getActualMetaData().nullsAreSortedLow();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getActualMetaData().nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getActualMetaData().nullsAreSortedAtEnd();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.getActualMetaData().getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.getActualMetaData().getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.getActualMetaData().getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getActualMetaData().getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            return this.getActualMetaData().getDriverMajorVersion();
        }
        catch (SQLException e) {
            String msg = "Failed to get actual meta data.";
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            return this.getActualMetaData().getDriverMinorVersion();
        }
        catch (SQLException e) {
            String msg = "Failed to get actual meta data.";
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getActualMetaData().usesLocalFiles();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getActualMetaData().usesLocalFilePerTable();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getActualMetaData().supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getActualMetaData().storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getActualMetaData().storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getActualMetaData().storesMixedCaseIdentifiers();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getActualMetaData().supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getActualMetaData().storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getActualMetaData().storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getActualMetaData().storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.getActualMetaData().getIdentifierQuoteString();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.getActualMetaData().getSQLKeywords();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.getActualMetaData().getNumericFunctions();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.getActualMetaData().getStringFunctions();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.getActualMetaData().getSystemFunctions();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.getActualMetaData().getTimeDateFunctions();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.getActualMetaData().getSearchStringEscape();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.getActualMetaData().getExtraNameCharacters();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.getActualMetaData().supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.getActualMetaData().supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.getActualMetaData().supportsColumnAliasing();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getActualMetaData().nullPlusNonNullIsNull();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.getActualMetaData().supportsConvert();
    }

    @Override
    public boolean supportsConvert(int i, int j) throws SQLException {
        return this.getActualMetaData().supportsConvert(i, j);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getActualMetaData().supportsTableCorrelationNames();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getActualMetaData().supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getActualMetaData().supportsExpressionsInOrderBy();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getActualMetaData().supportsOrderByUnrelated();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.getActualMetaData().supportsGroupBy();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getActualMetaData().supportsGroupByUnrelated();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getActualMetaData().supportsGroupByBeyondSelect();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getActualMetaData().supportsLikeEscapeClause();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getActualMetaData().supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getActualMetaData().supportsMultipleTransactions();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getActualMetaData().supportsNonNullableColumns();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.getActualMetaData().supportsMinimumSQLGrammar();
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.getActualMetaData().supportsCoreSQLGrammar();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getActualMetaData().supportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.getActualMetaData().supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.getActualMetaData().supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getActualMetaData().supportsANSI92FullSQL();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getActualMetaData().supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.getActualMetaData().supportsOuterJoins();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getActualMetaData().supportsFullOuterJoins();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getActualMetaData().supportsLimitedOuterJoins();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.getActualMetaData().getSchemaTerm();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.getActualMetaData().getProcedureTerm();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.getActualMetaData().getCatalogTerm();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getActualMetaData().isCatalogAtStart();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.getActualMetaData().getCatalogSeparator();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.getActualMetaData().supportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getActualMetaData().supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.getActualMetaData().supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getActualMetaData().supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getActualMetaData().supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.getActualMetaData().supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.getActualMetaData().supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.getActualMetaData().supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getActualMetaData().supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getActualMetaData().supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.getActualMetaData().supportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getActualMetaData().supportsPositionedUpdate();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getActualMetaData().supportsSelectForUpdate();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.getActualMetaData().supportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getActualMetaData().supportsSubqueriesInComparisons();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getActualMetaData().supportsSubqueriesInExists();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getActualMetaData().supportsSubqueriesInIns();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getActualMetaData().supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getActualMetaData().supportsCorrelatedSubqueries();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.getActualMetaData().supportsUnion();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.getActualMetaData().supportsUnionAll();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getActualMetaData().supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getActualMetaData().supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getActualMetaData().supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getActualMetaData().supportsOpenStatementsAcrossRollback();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getActualMetaData().getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getActualMetaData().getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getActualMetaData().getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getActualMetaData().getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getActualMetaData().getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getActualMetaData().getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getActualMetaData().getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getActualMetaData().getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.getActualMetaData().getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getActualMetaData().getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getActualMetaData().getMaxIndexLength();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getActualMetaData().getMaxSchemaNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getActualMetaData().getMaxProcedureNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getActualMetaData().getMaxCatalogNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getActualMetaData().getMaxRowSize();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getActualMetaData().doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getActualMetaData().getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getActualMetaData().getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getActualMetaData().getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getActualMetaData().getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getActualMetaData().getMaxUserNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getActualMetaData().getDefaultTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.getActualMetaData().supportsTransactions();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int i) throws SQLException {
        return this.getActualMetaData().supportsTransactionIsolationLevel(i);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getActualMetaData().supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getActualMetaData().supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getActualMetaData().dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getActualMetaData().dataDefinitionIgnoredInTransactions();
    }

    @Override
    public ResultSet getProcedures(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getProcedures(s, s1, s2);
    }

    @Override
    public ResultSet getProcedureColumns(String s, String s1, String s2, String s3) throws SQLException {
        return this.getActualMetaData().getProcedureColumns(s, s1, s2, s3);
    }

    @Override
    public ResultSet getTables(String s, String s1, String s2, String[] as) throws SQLException {
        return this.getActualMetaData().getTables(s, s1, s2, as);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getActualMetaData().getSchemas();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.getActualMetaData().getCatalogs();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.getActualMetaData().getTableTypes();
    }

    @Override
    public ResultSet getColumns(String s, String s1, String s2, String s3) throws SQLException {
        return this.getActualMetaData().getColumns(s, s1, s2, s3);
    }

    @Override
    public ResultSet getColumnPrivileges(String s, String s1, String s2, String s3) throws SQLException {
        return this.getActualMetaData().getColumnPrivileges(s, s1, s2, s3);
    }

    @Override
    public ResultSet getTablePrivileges(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getTablePrivileges(s, s1, s2);
    }

    @Override
    public ResultSet getBestRowIdentifier(String s, String s1, String s2, int i, boolean flag) throws SQLException {
        return this.getActualMetaData().getBestRowIdentifier(s, s1, s2, i, flag);
    }

    @Override
    public ResultSet getVersionColumns(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getVersionColumns(s, s1, s2);
    }

    @Override
    public ResultSet getPrimaryKeys(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getPrimaryKeys(s, s1, s2);
    }

    @Override
    public ResultSet getImportedKeys(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getImportedKeys(s, s1, s2);
    }

    @Override
    public ResultSet getExportedKeys(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getExportedKeys(s, s1, s2);
    }

    @Override
    public ResultSet getCrossReference(String s, String s1, String s2, String s3, String s4, String s5) throws SQLException {
        return this.getActualMetaData().getCrossReference(s, s1, s2, s3, s4, s5);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getActualMetaData().getTypeInfo();
    }

    @Override
    public ResultSet getIndexInfo(String s, String s1, String s2, boolean flag, boolean flag1) throws SQLException {
        return this.getActualMetaData().getIndexInfo(s, s1, s2, flag, flag1);
    }

    @Override
    public boolean supportsResultSetType(int i) throws SQLException {
        return this.getActualMetaData().supportsResultSetType(i);
    }

    @Override
    public boolean supportsResultSetConcurrency(int i, int j) throws SQLException {
        return this.getActualMetaData().supportsResultSetConcurrency(i, j);
    }

    @Override
    public boolean ownUpdatesAreVisible(int i) throws SQLException {
        return this.getActualMetaData().ownUpdatesAreVisible(i);
    }

    @Override
    public boolean ownDeletesAreVisible(int i) throws SQLException {
        return this.getActualMetaData().ownDeletesAreVisible(i);
    }

    @Override
    public boolean ownInsertsAreVisible(int i) throws SQLException {
        return this.getActualMetaData().ownInsertsAreVisible(i);
    }

    @Override
    public boolean othersUpdatesAreVisible(int i) throws SQLException {
        return this.getActualMetaData().othersUpdatesAreVisible(i);
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return this.getActualMetaData().othersDeletesAreVisible(i);
    }

    @Override
    public boolean othersInsertsAreVisible(int i) throws SQLException {
        return this.getActualMetaData().othersInsertsAreVisible(i);
    }

    @Override
    public boolean updatesAreDetected(int i) throws SQLException {
        return this.getActualMetaData().updatesAreDetected(i);
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return this.getActualMetaData().deletesAreDetected(i);
    }

    @Override
    public boolean insertsAreDetected(int i) throws SQLException {
        return this.getActualMetaData().insertsAreDetected(i);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.getActualMetaData().supportsBatchUpdates();
    }

    @Override
    public ResultSet getUDTs(String s, String s1, String s2, int[] ai) throws SQLException {
        return this.getActualMetaData().getUDTs(s, s1, s2, ai);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getActualMetaData().getConnection();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.getActualMetaData().supportsSavepoints();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.getActualMetaData().supportsNamedParameters();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.getActualMetaData().supportsMultipleOpenResults();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.getActualMetaData().supportsGetGeneratedKeys();
    }

    @Override
    public ResultSet getSuperTypes(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getSuperTypes(s, s1, s2);
    }

    @Override
    public ResultSet getSuperTables(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getSuperTables(s, s1, s2);
    }

    @Override
    public ResultSet getAttributes(String s, String s1, String s2, String s3) throws SQLException {
        return this.getActualMetaData().getAttributes(s, s1, s2, s3);
    }

    @Override
    public boolean supportsResultSetHoldability(int i) throws SQLException {
        return this.getActualMetaData().supportsResultSetHoldability(i);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getActualMetaData().getResultSetHoldability();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.getActualMetaData().getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.getActualMetaData().getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.getActualMetaData().getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.getActualMetaData().getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.getActualMetaData().getSQLStateType();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.getActualMetaData().locatorsUpdateCopy();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.getActualMetaData().supportsStatementPooling();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return this.getActualMetaData().getRowIdLifetime();
    }

    @Override
    public ResultSet getSchemas(String s, String s1) throws SQLException {
        return this.getActualMetaData().getSchemas(s, s1);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.getActualMetaData().supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.getActualMetaData().autoCommitFailureClosesAllResultSets();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getActualMetaData().getClientInfoProperties();
    }

    @Override
    public ResultSet getFunctions(String s, String s1, String s2) throws SQLException {
        return this.getActualMetaData().getFunctions(s, s1, s2);
    }

    @Override
    public ResultSet getFunctionColumns(String s, String s1, String s2, String s3) throws SQLException {
        return this.getActualMetaData().getFunctionColumns(s, s1, s2, s3);
    }
}

