/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.exception.handler;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.exception.EntityAlreadyExistsException;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.exception.handler.SQLExceptionAdviser;
import org.seasar.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;

public class SQLExceptionHandler {
    private static final Log _log = LogFactory.getLog(SQLExceptionHandler.class);
    protected final SQLExceptionAdviser _adviser = this.createAdviser();

    public void handleSQLException(SQLException e, SQLExceptionResource resource) {
        if (resource.isUniqueConstraintHandling() && this.isUniqueConstraintException(e)) {
            this.throwEntityAlreadyExistsException(e, resource);
        } else {
            this.throwSQLFailureException(e, resource);
        }
    }

    protected boolean isUniqueConstraintException(SQLException e) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        return ResourceContext.isUniqueConstraintException(this.extractSQLState(e), e.getErrorCode());
    }

    protected void throwEntityAlreadyExistsException(SQLException e, SQLExceptionResource resource) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity already exists on the database.");
        br.addItem("Advice");
        br.addElement("Please confirm the primary key whether it already exists on the database.");
        br.addElement("And also confirm the unique constraint for other columns.");
        this.setupCommonElement(br, e, resource);
        String msg = br.buildExceptionMessage();
        throw new EntityAlreadyExistsException(msg, e);
    }

    protected void throwSQLFailureException(SQLException e, SQLExceptionResource resource) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        List<String> noticeList = resource.getNoticeList();
        if (!noticeList.isEmpty()) {
            for (String notice : noticeList) {
                br.addNotice(notice);
            }
        } else {
            br.addNotice("The SQL failed to execute.");
        }
        br.addItem("Advice");
        br.addElement("Read the SQLException message.");
        String advice = this.askAdvice(e, ResourceContext.currentDBDef());
        if (advice != null && advice.trim().length() > 0) {
            br.addElement("*" + advice);
        }
        this.setupCommonElement(br, e, resource);
        String msg = br.buildExceptionMessage();
        throw new SQLFailureException(msg, e);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected String askAdvice(SQLException e, DBDef dbdef) {
        return this._adviser.askAdvice(e, dbdef);
    }

    protected void setupCommonElement(ExceptionMessageBuilder br, SQLException e, SQLExceptionResource resource) {
        br.addItem("SQLState");
        br.addElement(this.extractSQLState(e));
        br.addItem("ErrorCode");
        br.addElement(e.getErrorCode());
        this.setupSQLExceptionElement(br, e);
        Map<String, List<Object>> resourceMap = resource.getResourceMap();
        for (Map.Entry<String, List<Object>> entry : resourceMap.entrySet()) {
            br.addItem(entry.getKey());
            List<Object> elementList = entry.getValue();
            for (Object element : elementList) {
                br.addElement(element);
            }
        }
        this.setupBehaviorElement(br);
        this.setupConditionBeanElement(br);
        this.setupOutsideSqlElement(br);
        this.setupTargetSqlElement(br, resource);
    }

    protected void setupSQLExceptionElement(ExceptionMessageBuilder br, SQLException e) {
        br.addItem("SQLException");
        br.addElement(e.getClass().getName());
        br.addElement(this.extractMessage(e));
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addItem("NextException");
            br.addElement(nextEx.getClass().getName());
            br.addElement(this.extractMessage(nextEx));
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                br.addItem("NextNextException");
                br.addElement(nextNextEx.getClass().getName());
                br.addElement(this.extractMessage(nextNextEx));
            }
        }
    }

    protected void setupBehaviorElement(ExceptionMessageBuilder br) {
        String invokePath = this.extractBehaviorInvokePath();
        if (invokePath != null) {
            br.addItem("Behavior");
            br.addElement(invokePath);
        }
    }

    protected void setupConditionBeanElement(ExceptionMessageBuilder br) {
        if (this.hasConditionBean()) {
            br.addItem("ConditionBean");
            br.addElement(this.getConditionBean().getClass().getName());
        }
    }

    protected void setupOutsideSqlElement(ExceptionMessageBuilder br) {
        if (this.hasOutsideSqlContext()) {
            br.addItem("OutsideSql");
            br.addElement(this.getOutsideSqlContext().getOutsideSqlPath());
        }
    }

    protected void setupTargetSqlElement(ExceptionMessageBuilder br, SQLExceptionResource resource) {
        String displaySql = resource.getDisplaySql();
        if (displaySql != null) {
            if (resource.isDisplaySqlPartHandling()) {
                br.addItem("Display SQL (part of SQLs)");
            } else {
                br.addItem("Display SQL");
            }
            br.addElement(displaySql);
        }
    }

    protected String extractMessage(SQLException e) {
        String message = e.getMessage();
        return message != null ? message.trim() : message;
    }

    protected String extractSQLState(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextEx = e.getNextException();
        if (nextEx == null) {
            return null;
        }
        sqlState = nextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextEx = nextEx.getNextException();
        if (nextNextEx == null) {
            return null;
        }
        sqlState = nextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextNextEx = nextNextEx.getNextException();
        if (nextNextNextEx == null) {
            return null;
        }
        sqlState = nextNextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        return null;
    }

    protected String extractBehaviorInvokePath() {
        try {
            String provided = this.doExtractBehaviorInvokePathFromProvider();
            if (provided != null) {
                return provided;
            }
            return this.doExtractBehabiorInvokePathFromSeparatedParts();
        }
        catch (RuntimeException continued) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Failed to extract behavior invoke path for debug.", (Throwable)continued);
            }
            return null;
        }
    }

    protected String doExtractBehaviorInvokePathFromProvider() {
        InternalMapContext.InvokePathProvider provider = InternalMapContext.getInvokePathProvider();
        return provider != null ? provider.provide() : null;
    }

    protected String doExtractBehabiorInvokePathFromSeparatedParts() {
        String behaviorInvokeName = InternalMapContext.getBehaviorInvokeName();
        if (behaviorInvokeName == null) {
            return null;
        }
        String clientInvokeName = InternalMapContext.getClientInvokeName();
        String byPassInvokeName = InternalMapContext.getByPassInvokeName();
        StringBuilder sb = new StringBuilder();
        boolean existsPath = false;
        if (clientInvokeName != null) {
            existsPath = true;
            sb.append((Object)clientInvokeName);
        }
        if (byPassInvokeName != null) {
            existsPath = true;
            sb.append((Object)byPassInvokeName);
        }
        sb.append((Object)behaviorInvokeName);
        if (existsPath) {
            sb.append("...");
        }
        return sb.toString();
    }

    protected SQLExceptionAdviser createAdviser() {
        return new SQLExceptionAdviser();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected ConditionBean getConditionBean() {
        return ConditionBeanContext.getConditionBeanOnThread();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

