/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;
import org.apache.solr.spelling.suggest.LookupFactory;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSuggester {
    private static final Logger LOG = LoggerFactory.getLogger(SolrSuggester.class);
    public static final String DEFAULT_DICT_NAME = "default";
    public static final String NAME = "name";
    public static final String LOCATION = "sourceLocation";
    public static final String LOOKUP_IMPL = "lookupImpl";
    public static final String DICTIONARY_IMPL = "dictionaryImpl";
    public static final String STORE_DIR = "storeDir";
    static SuggesterResult EMPTY_RESULT = new SuggesterResult();
    private String sourceLocation;
    private File storeDir;
    private Dictionary dictionary;
    private Lookup lookup;
    private String lookupImpl;
    private String dictionaryImpl;
    private String name;
    private LookupFactory factory;
    private DictionaryFactory dictionaryFactory;

    public String init(NamedList<?> config, SolrCore core) {
        LOG.info("init: " + config);
        this.name = config.get(NAME) != null ? (String)config.get(NAME) : DEFAULT_DICT_NAME;
        this.sourceLocation = (String)config.get(LOCATION);
        this.lookupImpl = (String)config.get(LOOKUP_IMPL);
        this.dictionaryImpl = (String)config.get(DICTIONARY_IMPL);
        String store = (String)config.get(STORE_DIR);
        if (this.lookupImpl == null) {
            this.lookupImpl = LookupFactory.DEFAULT_FILE_BASED_DICT;
            LOG.info("No lookupImpl parameter was provided falling back to " + this.lookupImpl);
        }
        this.factory = core.getResourceLoader().newInstance(this.lookupImpl, LookupFactory.class);
        this.lookup = this.factory.create(config, core);
        if (store != null) {
            this.storeDir = new File(store);
            if (!this.storeDir.isAbsolute()) {
                this.storeDir = new File(core.getDataDir() + File.separator + this.storeDir);
            }
            if (!this.storeDir.exists()) {
                this.storeDir.mkdirs();
            } else {
                try {
                    this.lookup.load((InputStream)new FileInputStream(new File(this.storeDir, this.factory.storeFileName())));
                }
                catch (IOException e) {
                    LOG.warn("Loading stored lookup data failed, possibly not cached yet");
                }
            }
        }
        if (this.dictionaryImpl == null) {
            this.dictionaryImpl = this.sourceLocation == null ? DictionaryFactory.DEFAULT_INDEX_BASED_DICT : DictionaryFactory.DEFAULT_FILE_BASED_DICT;
            LOG.info("No dictionaryImpl parameter was provided falling back to " + this.dictionaryImpl);
        }
        this.dictionaryFactory = core.getResourceLoader().newInstance(this.dictionaryImpl, DictionaryFactory.class);
        this.dictionaryFactory.setParams(config);
        LOG.info("Dictionary loaded with params: " + config);
        return this.name;
    }

    public void build(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        LOG.info("build()");
        this.dictionary = this.dictionaryFactory.create(core, searcher);
        this.lookup.build(this.dictionary);
        if (this.storeDir != null) {
            File target = new File(this.storeDir, this.factory.storeFileName());
            if (!this.lookup.store((OutputStream)new FileOutputStream(target))) {
                LOG.error("Store Lookup build failed");
            } else {
                LOG.info("Stored suggest data to: " + target.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        LOG.info("reload()");
        if (this.dictionary == null && this.storeDir != null) {
            FileInputStream is;
            block3: {
                is = new FileInputStream(new File(this.storeDir, this.factory.storeFileName()));
                try {
                    if (!this.lookup.load((InputStream)is)) break block3;
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                return;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            LOG.debug("load failed, need to build Lookup again");
        }
        this.build(core, searcher);
    }

    public SuggesterResult getSuggestions(SuggesterOptions options) throws IOException {
        LOG.debug("getSuggestions: " + options.token);
        if (this.lookup == null) {
            LOG.info("Lookup is null - invoke suggest.build first");
            return EMPTY_RESULT;
        }
        SuggesterResult res = new SuggesterResult();
        List suggestions = this.lookup.lookup((CharSequence)options.token, false, options.count);
        res.add(this.getName(), options.token.toString(), suggestions);
        return res;
    }

    public String getName() {
        return this.name;
    }

    public long sizeInBytes() {
        return this.lookup.sizeInBytes();
    }

    public String toString() {
        return "SolrSuggester [ name=" + this.name + ", " + "sourceLocation=" + this.sourceLocation + ", " + "storeDir=" + (this.storeDir == null ? "" : this.storeDir.getAbsoluteFile()) + ", " + "lookupImpl=" + this.lookupImpl + ", " + "dictionaryImpl=" + this.dictionaryImpl + ", " + "sizeInBytes=" + (this.lookup != null ? String.valueOf(this.sizeInBytes()) : "0") + " ]";
    }
}

