/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;

public class BitDocSet
extends DocSetBase {
    final FixedBitSet bits;
    int size;

    public BitDocSet() {
        this.bits = new FixedBitSet(64);
    }

    public BitDocSet(FixedBitSet bits) {
        this.bits = bits;
        this.size = -1;
    }

    public BitDocSet(FixedBitSet bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            private final FixedBitSet.FixedBitSetIterator iter;
            private int pos;
            {
                this.iter = new FixedBitSet.FixedBitSetIterator(BitDocSet.this.bits);
                this.pos = this.iter.nextDoc();
            }

            @Override
            public boolean hasNext() {
                return this.pos != Integer.MAX_VALUE;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                BitDocSet.this.bits.clear(this.pos);
            }

            @Override
            public int nextDoc() {
                int old = this.pos;
                this.pos = this.iter.nextDoc();
                return old;
            }

            @Override
            public float score() {
                return 0.0f;
            }
        };
    }

    @Override
    public FixedBitSet getBits() {
        return this.bits;
    }

    @Override
    public void add(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    @Override
    public void addUnique(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    @Override
    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = this.bits.cardinality();
        return this.size;
    }

    public void invalidateSize() {
        this.size = -1;
    }

    @Override
    public boolean exists(int doc) {
        return this.bits.get(doc);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.intersectionCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return other.intersectionSize(this);
    }

    @Override
    public boolean intersects(DocSet other) {
        if (other instanceof BitDocSet) {
            return this.bits.intersects(((BitDocSet)other).bits);
        }
        return other.intersects(this);
    }

    @Override
    public int unionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.unionCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return other.unionSize(this);
    }

    @Override
    public int andNotSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.andNotCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return super.andNotSize(other);
    }

    @Override
    public void addAllTo(DocSet target) {
        if (target instanceof BitDocSet) {
            ((BitDocSet)target).bits.or(this.bits);
        } else {
            super.addAllTo(target);
        }
    }

    @Override
    public DocSet andNot(DocSet other) {
        FixedBitSet newbits = this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.andNot(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                if (doc >= newbits.length()) continue;
                newbits.clear(doc);
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public DocSet union(DocSet other) {
        FixedBitSet newbits = this.bits.clone();
        if (other instanceof BitDocSet) {
            BitDocSet otherDocSet = (BitDocSet)other;
            newbits = FixedBitSet.ensureCapacity((FixedBitSet)newbits, (int)otherDocSet.bits.length());
            newbits.or(otherDocSet.bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                newbits = FixedBitSet.ensureCapacity((FixedBitSet)newbits, (int)doc);
                newbits.set(doc);
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public long memSize() {
        return (this.bits.getBits().length << 3) + 16;
    }

    protected BitDocSet clone() {
        return new BitDocSet(this.bits.clone(), this.size);
    }

    @Override
    public Filter getTopFilter() {
        final FixedBitSet bs = this.bits;
        return new Filter(){

            public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) {
                Bits acceptDocs2;
                AtomicReader reader = context.reader();
                Bits bits = acceptDocs == null ? null : (acceptDocs2 = reader.getLiveDocs() == acceptDocs ? null : acceptDocs);
                if (context.isTopLevel) {
                    return BitsFilteredDocIdSet.wrap((DocIdSet)bs, (Bits)acceptDocs);
                }
                final int base = context.docBase;
                final int maxDoc = reader.maxDoc();
                final int max = base + maxDoc;
                return BitsFilteredDocIdSet.wrap((DocIdSet)new DocIdSet(){

                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){
                            int pos;
                            int adjustedDoc;
                            {
                                this.pos = base - 1;
                                this.adjustedDoc = -1;
                            }

                            public int docID() {
                                return this.adjustedDoc;
                            }

                            public int nextDoc() {
                                if (this.pos >= bs.length() - 1) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(this.pos + 1);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            public int advance(int target) {
                                if (target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                int adjusted = target + base;
                                if (adjusted >= bs.length()) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(adjusted);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            public long cost() {
                                if (BitDocSet.this.size != -1) {
                                    return (long)((float)BitDocSet.this.size * ((float)(FixedBitSet.bits2words((int)maxDoc) << 6) / (float)bs.length()));
                                }
                                return maxDoc;
                            }
                        };
                    }

                    public boolean isCacheable() {
                        return true;
                    }

                    public Bits bits() {
                        return new Bits(){

                            public boolean get(int index) {
                                return bs.get(index + base);
                            }

                            public int length() {
                                return maxDoc;
                            }
                        };
                    }
                }, (Bits)acceptDocs2);
            }
        };
    }
}

