/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.solr.util.NumberUtils;

@Deprecated
class SortableFloatFieldSource
extends FieldCacheSource {
    protected float defVal;
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public SortableFloatFieldSource(String field) {
        this(field, 0.0f);
    }

    public SortableFloatFieldSource(String field, float defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "sfloat(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final float def = this.defVal;
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){
            private final BytesRef spare;
            {
                super(x0, x1, x2);
                this.spare = new BytesRef();
            }

            protected String toTerm(String readableValue) {
                return NumberUtils.float2sortableStr(readableValue);
            }

            public boolean exists(int doc) {
                return this.termsIndex.getOrd(doc) >= 0;
            }

            public float floatVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == -1) {
                    return def;
                }
                this.termsIndex.lookupOrd(ord, this.spare);
                return NumberUtils.SortableStr2float(this.spare);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return SortableFloatFieldSource.this.description() + '=' + this.floatVal(doc);
            }

            public Object objectVal(int doc) {
                return this.exists(doc) ? Float.valueOf(this.floatVal(doc)) : null;
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueFloat mval = new MutableValueFloat();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == -1) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            termsIndex.lookupOrd(ord, spare);
                            this.mval.value = NumberUtils.SortableStr2float(spare);
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableFloatFieldSource && super.equals(o) && this.defVal == ((SortableFloatFieldSource)((Object)o)).defVal;
    }

    public int hashCode() {
        return hcode + super.hashCode() + Float.floatToIntBits(this.defVal);
    }
}

