/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema.analysis;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.schema.analysis.BaseManagedTokenFilterFactory;
import org.apache.solr.rest.schema.analysis.ManagedWordSetResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedStopFilterFactory
extends BaseManagedTokenFilterFactory {
    public static final Logger log = LoggerFactory.getLogger(ManagedStopFilterFactory.class);
    private CharArraySet stopWords = null;

    public ManagedStopFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public String getResourceId() {
        return "/schema/analysis/stopwords/" + this.handle;
    }

    @Override
    protected Class<? extends ManagedResource> getManagedResourceImplClass() {
        return ManagedWordSetResource.class;
    }

    @Override
    public void onManagedResourceInitialized(NamedList<?> args, ManagedResource res) throws SolrException {
        Set<String> managedWords = ((ManagedWordSetResource)res).getWordSet();
        boolean ignoreCase = args.getBooleanArg("ignoreCase");
        this.stopWords = new CharArraySet(this.luceneMatchVersion, managedWords.size(), ignoreCase);
        this.stopWords.addAll(managedWords);
    }

    public TokenStream create(TokenStream input) {
        if (this.stopWords == null) {
            throw new IllegalStateException("Managed stopwords not initialized correctly!");
        }
        return new StopFilter(this.luceneMatchVersion, input, this.stopWords);
    }
}

