/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.POSTable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFieldCollectionResource
extends BaseFieldResource
implements GETable,
POSTable {
    private static final Logger log = LoggerFactory.getLogger(CopyFieldCollectionResource.class);
    private static final String SOURCE_FIELD_LIST = "source.fl";
    private static final String DESTINATION_FIELD_LIST = "dest.fl";
    private Set<String> requestedSourceFields;
    private Set<String> requestedDestinationFields;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            String[] fields;
            String destinationFieldListParam;
            String[] fields2;
            String sourceFieldListParam = this.getSolrRequest().getParams().get(SOURCE_FIELD_LIST);
            if (null != sourceFieldListParam && (fields2 = sourceFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedSourceFields = new HashSet<String>(Arrays.asList(fields2));
                this.requestedSourceFields.remove("");
            }
            if (null != (destinationFieldListParam = this.getSolrRequest().getParams().get(DESTINATION_FIELD_LIST)) && (fields = destinationFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedDestinationFields = new HashSet<String>(Arrays.asList(fields));
                this.requestedDestinationFields.remove("");
            }
        }
    }

    @Override
    public Representation get() {
        try {
            this.getSolrResponse().add("copyFields", this.getSchema().getCopyFieldProperties(true, this.requestedSourceFields, this.requestedDestinationFields));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    @Override
    public Representation post(Representation entity) throws ResourceException {
        try {
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON((String)entity.getText());
            if (!(object instanceof List)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected List of the form" + " (ignore the backslashes): [{\"source\":\"foo\",\"dest\":\"comma-separated list of targets\"}, {...}, ...]";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            List list = (List)object;
            HashMap<String, List<String>> fieldsToCopy = new HashMap<String, List<String>>();
            ManagedIndexSchema oldSchema = (ManagedIndexSchema)this.getSchema();
            HashSet<String> malformed = new HashSet<String>();
            for (Map map : list) {
                String fieldName = (String)map.get("source");
                if (null == fieldName) {
                    String message = "Missing 'source' mapping.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                Object dest = map.get("dest");
                List<String> destinations = null;
                if (dest != null) {
                    if (dest instanceof List) {
                        destinations = (List<String>)dest;
                    } else if (dest instanceof String) {
                        destinations = Collections.singletonList(dest.toString());
                    } else {
                        String message = "Invalid 'dest' type.";
                        log.error(message);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                }
                if (destinations == null) {
                    malformed.add(fieldName);
                    continue;
                }
                fieldsToCopy.put(fieldName, destinations);
            }
            if (malformed.size() > 0) {
                StringBuilder message = new StringBuilder("Malformed destination(s) for: ");
                for (String s : malformed) {
                    message.append(s).append(", ");
                }
                if (message.length() > 2) {
                    message.setLength(message.length() - 2);
                }
                log.error(message.toString().trim());
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message.toString().trim());
            }
            IndexSchema newSchema = oldSchema.addCopyFields(fieldsToCopy);
            if (newSchema != null) {
                this.getSolrCore().setLatestSchema(newSchema);
            }
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

