/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.internal.csv.CSVPrinter;
import org.apache.solr.internal.csv.CSVStrategy;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.util.FastWriter;

class CSVWriter
extends TextResponseWriter {
    static String SEPARATOR = "separator";
    static String ENCAPSULATOR = "encapsulator";
    static String ESCAPE = "escape";
    static String CSV = "csv.";
    static String CSV_SEPARATOR = CSV + SEPARATOR;
    static String CSV_ENCAPSULATOR = CSV + ENCAPSULATOR;
    static String CSV_ESCAPE = CSV + ESCAPE;
    static String MV = CSV + "mv.";
    static String MV_SEPARATOR = MV + SEPARATOR;
    static String MV_ENCAPSULATOR = MV + ENCAPSULATOR;
    static String MV_ESCAPE = MV + ESCAPE;
    static String CSV_NULL = CSV + "null";
    static String CSV_HEADER = CSV + "header";
    static String CSV_NEWLINE = CSV + "newline";
    char[] sharedCSVBuf = new char[8192];
    int pass;
    Map<String, CSVField> csvFields = new LinkedHashMap<String, CSVField>();
    Calendar cal;
    CSVStrategy strategy;
    CSVPrinter printer;
    ResettableFastWriter mvWriter = new ResettableFastWriter();
    String NullValue;
    List tmpList;

    public CSVWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeResponse() throws IOException {
        CSVStrategy mvStrategy;
        String nl;
        SolrParams params = this.req.getParams();
        CSVStrategy strat = this.strategy = new CSVStrategy(',', '\"', CSVStrategy.COMMENTS_DISABLED, CSVStrategy.ESCAPE_DISABLED, false, false, false, true);
        String sep = params.get(CSV_SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid separator:'" + sep + "'");
            }
            strat.setDelimiter(sep.charAt(0));
        }
        if ((nl = params.get(CSV_NEWLINE)) != null) {
            if (nl.length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid newline:'" + nl + "'");
            }
            strat.setPrinterNewline(nl);
        }
        String encapsulator = params.get(CSV_ENCAPSULATOR);
        String escape = params.get(CSV_ESCAPE);
        if (encapsulator != null) {
            if (encapsulator.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid encapsulator:'" + encapsulator + "'");
            }
            strat.setEncapsulator(encapsulator.charAt(0));
        }
        if (escape != null) {
            if (escape.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid escape:'" + escape + "'");
            }
            strat.setEscape(escape.charAt(0));
            if (encapsulator == null) {
                strat.setEncapsulator(CSVStrategy.ENCAPSULATOR_DISABLED);
            }
        }
        if (strat.getEscape() == '\\') {
            strat.setUnicodeEscapeInterpretation(true);
        }
        this.printer = new CSVPrinter(this.writer, this.strategy);
        strat = mvStrategy = new CSVStrategy(this.strategy.getDelimiter(), CSVStrategy.ENCAPSULATOR_DISABLED, CSVStrategy.COMMENTS_DISABLED, '\\', false, false, false, false);
        sep = params.get(MV_SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv separator:'" + sep + "'");
            }
            strat.setDelimiter(sep.charAt(0));
        }
        encapsulator = params.get(MV_ENCAPSULATOR);
        escape = params.get(MV_ESCAPE);
        if (encapsulator != null) {
            if (encapsulator.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv encapsulator:'" + encapsulator + "'");
            }
            strat.setEncapsulator(encapsulator.charAt(0));
            if (escape == null) {
                strat.setEscape(CSVStrategy.ESCAPE_DISABLED);
            }
        }
        if ((escape = params.get(MV_ESCAPE)) != null) {
            if (escape.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv escape:'" + escape + "'");
            }
            strat.setEscape(escape.charAt(0));
        }
        Collection<String> fields = this.returnFields.getRequestedFieldNames();
        Object responseObj = this.rsp.getValues().get("response");
        boolean returnOnlyStored = false;
        if (fields == null || this.returnFields.hasPatternMatching()) {
            if (responseObj instanceof SolrDocumentList) {
                if (fields == null) {
                    fields = new LinkedHashSet<String>();
                }
                for (SolrDocument sdoc : (SolrDocumentList)responseObj) {
                    fields.addAll(sdoc.getFieldNames());
                }
            } else {
                Collection<String> all = this.req.getSearcher().getFieldNames();
                if (fields == null) {
                    fields = all;
                } else {
                    fields.addAll(all);
                }
            }
            if (this.returnFields.wantsScore()) {
                fields.add("score");
            } else {
                fields.remove("score");
            }
            returnOnlyStored = true;
        }
        CSVSharedBufPrinter csvPrinterMV = new CSVSharedBufPrinter(this.mvWriter, mvStrategy);
        for (String field : fields) {
            if (!this.returnFields.wantsField(field)) continue;
            if (field.equals("score")) {
                CSVField csvField = new CSVField();
                csvField.name = "score";
                this.csvFields.put("score", csvField);
                continue;
            }
            SchemaField sf = this.schema.getFieldOrNull(field);
            if (sf == null) {
                StrField ft = new StrField();
                sf = new SchemaField(field, ft);
            }
            if (returnOnlyStored && sf != null && !sf.stored()) continue;
            sep = params.get("f." + field + '.' + CSV_SEPARATOR);
            encapsulator = params.get("f." + field + '.' + CSV_ENCAPSULATOR);
            escape = params.get("f." + field + '.' + CSV_ESCAPE);
            if (sf.isPolyField()) {
                escape = escape == null ? "\\" : escape;
            }
            CSVSharedBufPrinter csvPrinter = csvPrinterMV;
            if (sep != null || encapsulator != null || escape != null) {
                strat = (CSVStrategy)mvStrategy.clone();
                if (sep != null) {
                    if (sep.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv separator:'" + sep + "'");
                    }
                    strat.setDelimiter(sep.charAt(0));
                }
                if (encapsulator != null) {
                    if (encapsulator.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv encapsulator:'" + encapsulator + "'");
                    }
                    strat.setEncapsulator(encapsulator.charAt(0));
                    if (escape == null) {
                        strat.setEscape(CSVStrategy.ESCAPE_DISABLED);
                    }
                }
                if (escape != null) {
                    if (escape.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv escape:'" + escape + "'");
                    }
                    strat.setEscape(escape.charAt(0));
                    if (encapsulator == null) {
                        strat.setEncapsulator(CSVStrategy.ENCAPSULATOR_DISABLED);
                    }
                }
                csvPrinter = new CSVSharedBufPrinter(this.mvWriter, strat);
            }
            CSVField csvField = new CSVField();
            csvField.name = field;
            csvField.sf = sf;
            csvField.mvPrinter = csvPrinter;
            this.csvFields.put(field, csvField);
        }
        this.NullValue = params.get(CSV_NULL, "");
        if (params.getBool(CSV_HEADER, true)) {
            for (CSVField csvField : this.csvFields.values()) {
                this.printer.print(csvField.name);
            }
            this.printer.println();
        }
        if (responseObj instanceof ResultContext) {
            this.writeDocuments(null, (ResultContext)responseObj, this.returnFields);
        } else if (responseObj instanceof DocList) {
            ResultContext ctx = new ResultContext();
            ctx.docs = (DocList)responseObj;
            this.writeDocuments(null, ctx, this.returnFields);
        } else if (responseObj instanceof SolrDocumentList) {
            this.writeSolrDocumentList(null, (SolrDocumentList)responseObj, this.returnFields);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.printer != null) {
            this.printer.flush();
        }
        super.close();
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
    }

    @Override
    public void writeEndDocumentList() throws IOException {
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (this.tmpList == null) {
            this.tmpList = new ArrayList(1);
            this.tmpList.add(null);
        }
        for (CSVField csvField : this.csvFields.values()) {
            Collection values;
            int nVals;
            Object val = doc.getFieldValue(csvField.name);
            int n = val instanceof Collection ? ((Collection)val).size() : (nVals = val == null ? 0 : 1);
            if (nVals == 0) {
                this.writeNull(csvField.name);
                continue;
            }
            if (csvField.sf != null && csvField.sf.multiValued() || nVals > 1) {
                if (val instanceof Collection) {
                    values = (Collection)val;
                } else {
                    this.tmpList.set(0, val);
                    values = this.tmpList;
                }
                this.mvWriter.reset();
                csvField.mvPrinter.reset();
                CSVPrinter tmp = this.printer;
                this.printer = csvField.mvPrinter;
                for (Object fval : values) {
                    this.writeVal(csvField.name, fval);
                }
                this.printer = tmp;
                this.mvWriter.freeze();
                this.printer.print(this.mvWriter.getFrozenBuf(), 0, this.mvWriter.getFrozenSize(), true);
                continue;
            }
            if (val instanceof Collection) {
                values = (Collection)val;
                val = values.iterator().next();
            }
            if (csvField.sf != null && csvField.sf.isPolyField()) {
                this.mvWriter.reset();
                csvField.mvPrinter.reset();
                CSVPrinter tmp = this.printer;
                this.printer = csvField.mvPrinter;
                this.writeVal(csvField.name, val);
                this.printer = tmp;
                this.mvWriter.freeze();
                this.printer.print(this.mvWriter.getFrozenBuf(), 0, this.mvWriter.getFrozenSize(), true);
                continue;
            }
            this.writeVal(csvField.name, val);
        }
        this.printer.println();
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.printer.print(val, needsEscaping);
    }

    @Override
    public void writeMap(String name, Map val, boolean excludeOuter, boolean isFirstVal) throws IOException {
    }

    @Override
    public void writeArray(String name, Iterator val) throws IOException {
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.printer.print(this.NullValue);
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeDate(String name, Date val) throws IOException {
        StringBuilder sb = new StringBuilder(25);
        this.cal = DateUtil.formatDate((Date)val, (Calendar)this.cal, (Appendable)sb);
        this.writeDate(name, sb.toString());
    }

    @Override
    public void writeDate(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    static class CSVField {
        String name;
        SchemaField sf;
        CSVSharedBufPrinter mvPrinter;
        List<IndexableField> values = new ArrayList<IndexableField>(1);
        int tmp;

        CSVField() {
        }
    }

    static class ResettableFastWriter
    extends FastWriter {
        OpenCharArrayWriter cw = (OpenCharArrayWriter)this.sink;
        char[] result;
        int resultLen;

        public ResettableFastWriter() {
            super(new OpenCharArrayWriter());
        }

        public void reset() {
            this.cw.reset();
            this.pos = 0;
        }

        public void freeze() throws IOException {
            if (this.cw.size() > 0) {
                this.flush();
                this.result = this.cw.getInternalBuf();
                this.resultLen = this.cw.size();
            } else {
                this.result = this.buf;
                this.resultLen = this.pos;
            }
        }

        public int getFrozenSize() {
            return this.resultLen;
        }

        public char[] getFrozenBuf() {
            return this.result;
        }
    }

    static class OpenCharArrayWriter
    extends CharArrayWriter {
        OpenCharArrayWriter() {
        }

        public char[] getInternalBuf() {
            return this.buf;
        }
    }

    class CSVSharedBufPrinter
    extends CSVPrinter {
        public CSVSharedBufPrinter(Writer out, CSVStrategy strategy) {
            super(out, strategy);
            this.buf = CSVWriter.this.sharedCSVBuf;
        }

        public void reset() {
            this.newLine = true;
            CSVWriter.this.sharedCSVBuf = this.buf;
        }
    }
}

