/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeGetComponent
extends SearchComponent {
    public static Logger log = LoggerFactory.getLogger(UpdateLog.class);
    public static final String COMPONENT_NAME = "get";
    public static SolrInputDocument DELETED = new SolrInputDocument();

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrReturnFields returnFields = new SolrReturnFields(rb.req);
        rb.rsp.setReturnFields(returnFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        String[] allIds;
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String val = params.get("getVersions");
        if (val != null) {
            this.processGetVersions(rb);
            return;
        }
        val = params.get("getUpdates");
        if (val != null) {
            this.processGetUpdates(rb);
            return;
        }
        String[] id = params.getParams("id");
        String[] ids = params.getParams("ids");
        if (id == null && ids == null) {
            return;
        }
        String[] stringArray = allIds = id == null ? new String[]{} : id;
        if (ids != null) {
            ArrayList<String> lst = new ArrayList<String>();
            for (String s : allIds) {
                lst.add(s);
            }
            for (String idList : ids) {
                lst.addAll(StrUtils.splitSmart((String)idList, (String)",", (boolean)true));
            }
            allIds = lst.toArray(new String[lst.size()]);
        }
        SolrCore core = req.getCore();
        SchemaField idField = core.getLatestSchema().getUniqueKeyField();
        FieldType fieldType = idField.getType();
        SolrDocumentList docList = new SolrDocumentList();
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        DocTransformer transformer = rsp.getReturnFields().getTransformer();
        if (transformer != null) {
            TransformContext context = new TransformContext();
            context.req = req;
            transformer.setContext(context);
        }
        try {
            SolrIndexSearcher searcher = null;
            BytesRef idBytes = new BytesRef();
            for (String idStr : allIds) {
                int docid;
                Object o;
                fieldType.readableToIndexed(idStr, idBytes);
                if (ulog != null && (o = ulog.lookup(idBytes)) != null) {
                    List entry = (List)o;
                    assert (entry.size() >= 3);
                    int oper = (Integer)entry.get(0) & 0xF;
                    switch (oper) {
                        case 1: {
                            SolrDocument doc = RealTimeGetComponent.toSolrDoc((SolrInputDocument)entry.get(entry.size() - 1), core.getLatestSchema());
                            if (transformer != null) {
                                transformer.transform(doc, -1);
                            }
                            docList.add((Object)doc);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                        }
                    }
                    continue;
                }
                if (searcher == null) {
                    searcherHolder = core.getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                if ((docid = searcher.getFirstMatch(new Term(idField.getName(), idBytes))) < 0) continue;
                Document luceneDocument = searcher.doc(docid);
                SolrDocument doc = RealTimeGetComponent.toSolrDoc(luceneDocument, core.getLatestSchema());
                if (transformer != null) {
                    transformer.transform(doc, docid);
                }
                docList.add((Object)doc);
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        if (ids == null && allIds.length <= 1) {
            rsp.add("doc", docList.size() > 0 ? (SolrDocument)docList.get(0) : null);
        } else {
            docList.setNumFound((long)docList.size());
            rsp.add("response", docList);
        }
    }

    public static SolrInputDocument getInputDocumentFromTlog(SolrCore core, BytesRef idBytes) {
        Object o;
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog != null && (o = ulog.lookup(idBytes)) != null) {
            List entry = (List)o;
            assert (entry.size() >= 3);
            int oper = (Integer)entry.get(0) & 0xF;
            switch (oper) {
                case 1: {
                    return (SolrInputDocument)entry.get(entry.size() - 1);
                }
                case 2: {
                    return DELETED;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrInputDocument getInputDocument(SolrCore core, BytesRef idBytes) throws IOException {
        SolrInputDocument sid = null;
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        try {
            SolrIndexSearcher searcher = null;
            sid = RealTimeGetComponent.getInputDocumentFromTlog(core, idBytes);
            if (sid == DELETED) {
                SolrInputDocument solrInputDocument = null;
                return solrInputDocument;
            }
            if (sid == null) {
                SchemaField idField;
                int docid;
                if (searcher == null) {
                    searcherHolder = core.getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                if ((docid = searcher.getFirstMatch(new Term((idField = core.getLatestSchema().getUniqueKeyField()).getName(), idBytes))) < 0) {
                    SolrInputDocument solrInputDocument = null;
                    return solrInputDocument;
                }
                Document luceneDocument = searcher.doc(docid);
                sid = RealTimeGetComponent.toSolrInputDocument(luceneDocument, core.getLatestSchema());
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        return sid;
    }

    private static SolrInputDocument toSolrInputDocument(Document doc, IndexSchema schema) {
        SolrInputDocument out = new SolrInputDocument();
        for (IndexableField f : doc.getFields()) {
            String fname = f.name();
            SchemaField sf = schema.getFieldOrNull(f.name());
            Object val = null;
            if (sf != null) {
                if (!sf.stored() || schema.isCopyFieldTarget(sf)) continue;
                val = sf.getType().toObject(f);
            } else {
                val = f.stringValue();
                if (val == null) {
                    val = f.numericValue();
                }
                if (val == null) {
                    val = f.binaryValue();
                }
                if (val == null) {
                    val = f;
                }
            }
            out.addField(fname, val);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get((Object)f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && schema.isCopyFieldTarget(sf)) continue;
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), (Object)f);
                continue;
            }
            out.addField(f.name(), (Object)f);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(SolrInputDocument sdoc, IndexSchema schema) {
        Document doc = DocumentBuilder.toDocument(sdoc, schema);
        Document out = new Document();
        for (IndexableField f : doc.getFields()) {
            if (!f.fieldType().stored()) continue;
            out.add(f);
        }
        return RealTimeGetComponent.toSolrDoc(out, schema);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            return this.createSubRequests(rb);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public int createSubRequests(ResponseBuilder rb) throws IOException {
        ZkController zkController;
        SolrParams params = rb.req.getParams();
        String[] id1 = params.getParams("id");
        String[] ids = params.getParams("ids");
        if (id1 == null && ids == null) {
            return ResponseBuilder.STAGE_DONE;
        }
        ArrayList<String> allIds = new ArrayList<String>();
        if (id1 != null) {
            for (String s : id1) {
                allIds.add(s);
            }
        }
        if (ids != null) {
            for (String s : ids) {
                allIds.addAll(StrUtils.splitSmart((String)s, (String)",", (boolean)true));
            }
        }
        if ((zkController = rb.req.getCore().getCoreDescriptor().getCoreContainer().getZkController()) != null && params.get("shards") == null) {
            CloudDescriptor cloudDescriptor = rb.req.getCore().getCoreDescriptor().getCloudDescriptor();
            String collection = cloudDescriptor.getCollectionName();
            ClusterState clusterState = zkController.getClusterState();
            DocCollection coll = clusterState.getCollection(collection);
            HashMap<String, ArrayList<String>> sliceToId = new HashMap<String, ArrayList<String>>();
            for (String string : allIds) {
                Slice slice = coll.getRouter().getTargetSlice(string, null, params, coll);
                ArrayList<String> idsForShard = (ArrayList<String>)sliceToId.get(slice.getName());
                if (idsForShard == null) {
                    idsForShard = new ArrayList<String>(2);
                    sliceToId.put(slice.getName(), idsForShard);
                }
                idsForShard.add(string);
            }
            for (Map.Entry entry : sliceToId.entrySet()) {
                String shard = (String)entry.getKey();
                String shardIdList = StrUtils.join((List)((List)entry.getValue()), (char)',');
                ShardRequest sreq = new ShardRequest();
                sreq.purpose = 1;
                sreq.shards = this.sliceToShards(rb, collection, shard);
                sreq.actualShards = sreq.shards;
                sreq.params = new ModifiableSolrParams();
                sreq.params.set("shards.qt", new String[]{"/get"});
                sreq.params.set("distrib", false);
                sreq.params.set("ids", new String[]{shardIdList});
                rb.addRequest(this, sreq);
            }
        } else {
            String shardIdList = StrUtils.join(allIds, (char)',');
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 1;
            sreq.shards = null;
            sreq.actualShards = sreq.shards;
            sreq.params = new ModifiableSolrParams();
            sreq.params.set("shards.qt", new String[]{"/get"});
            sreq.params.set("distrib", false);
            sreq.params.set("ids", new String[]{shardIdList});
            rb.addRequest(this, sreq);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    private String[] sliceToShards(ResponseBuilder rb, String collection, String slice) {
        String lookup = collection + '_' + slice;
        for (int i = 0; i < rb.slices.length; ++i) {
            log.info("LOOKUP_SLICE:" + rb.slices[i] + "=" + rb.shards[i]);
            if (!lookup.equals(rb.slices[i]) && !slice.equals(rb.slices[i])) continue;
            return new String[]{rb.shards[i]};
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find shard '" + lookup + "'");
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        this.mergeResponses(rb);
    }

    private void mergeResponses(ResponseBuilder rb) {
        SolrDocumentList docList = new SolrDocumentList();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                SolrResponse sr = srsp.getSolrResponse();
                NamedList nl = sr.getResponse();
                SolrDocumentList subList = (SolrDocumentList)nl.get("response");
                docList.addAll((Collection)subList);
            }
        }
        if (docList.size() <= 1 && rb.req.getParams().getParams("ids") == null) {
            rb.rsp.add("doc", docList.size() > 0 ? (SolrDocument)docList.get(0) : null);
        } else {
            docList.setNumFound((long)docList.size());
            rb.rsp.add("response", docList);
        }
    }

    @Override
    public String getDescription() {
        return "query";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_8/solr/core/src/java/org/apache/solr/handler/component/RealTimeGetComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGetVersions(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        int nVersions = params.getInt("getVersions", -1);
        if (nVersions == -1) {
            return;
        }
        String sync = params.get("sync");
        if (sync != null) {
            this.processSync(rb, nVersions, sync);
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            rb.rsp.add("versions", recentUpdates.getVersions(nVersions));
        }
    }

    public void processSync(ResponseBuilder rb, int nVersions, String sync) {
        boolean onlyIfActive = rb.req.getParams().getBool("onlyIfActive", false);
        if (onlyIfActive && !rb.req.getCore().getCoreDescriptor().getCloudDescriptor().getLastPublished().equals("active")) {
            log.info("Last published state was not ACTIVE, cannot sync.");
            rb.rsp.add("sync", "false");
            return;
        }
        List replicas = StrUtils.splitSmart((String)sync, (String)",", (boolean)true);
        boolean cantReachIsSuccess = rb.req.getParams().getBool("cantReachIsSuccess", false);
        PeerSync peerSync = new PeerSync(rb.req.getCore(), replicas, nVersions, cantReachIsSuccess, true);
        boolean success = peerSync.sync();
        rb.rsp.add("sync", success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGetUpdates(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String versionsStr = params.get("getUpdates");
        if (versionsStr == null) {
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        List versions = StrUtils.splitSmart((String)versionsStr, (String)",", (boolean)true);
        ArrayList<Object> updates = new ArrayList<Object>(versions.size());
        long minVersion = Long.MAX_VALUE;
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            for (String versionStr : versions) {
                long version = Long.parseLong(versionStr);
                try {
                    Object o = recentUpdates.lookup(version);
                    if (o == null) continue;
                    if (version > 0L) {
                        minVersion = Math.min(minVersion, version);
                    }
                    updates.add(o);
                }
                catch (SolrException e) {
                    log.warn("Exception reading log for updates", (Throwable)e);
                }
                catch (ClassCastException e) {
                    log.warn("Exception reading log for updates", (Throwable)e);
                }
            }
            updates.addAll(recentUpdates.getDeleteByQuery(minVersion));
            rb.rsp.add("updates", updates);
        }
    }
}

