/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(SystemInfoHandler.class);
    private String hostname = null;
    private CoreContainer cc;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public SystemInfoHandler() {
        this.init();
    }

    public SystemInfoHandler(CoreContainer cc) {
        this.cc = cc;
        this.init();
    }

    private void init() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        boolean solrCloudMode;
        SolrCore core = req.getCore();
        if (core != null) {
            rsp.add("core", this.getCoreInfo(core, req.getSchema()));
        }
        rsp.add("mode", (solrCloudMode = this.getCoreContainer(req, core).isZooKeeperAware()) ? "solrcloud" : "std");
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
        rsp.setHttpCaching(false);
    }

    private CoreContainer getCoreContainer(SolrQueryRequest req, SolrCore core) {
        CoreContainer coreContainer = core != null ? req.getCore().getCoreDescriptor().getCoreContainer() : this.cc;
        return coreContainer;
    }

    private SimpleOrderedMap<Object> getCoreInfo(SolrCore core, IndexSchema schema) {
        SimpleOrderedMap info = new SimpleOrderedMap();
        info.add("schema", (Object)(schema != null ? schema.getSchemaName() : "no schema!"));
        info.add("host", (Object)this.hostname);
        info.add("now", (Object)new Date());
        info.add("start", (Object)new Date(core.getStartTime()));
        SimpleOrderedMap dirs = new SimpleOrderedMap();
        dirs.add("cwd", (Object)new File(System.getProperty("user.dir")).getAbsolutePath());
        dirs.add("instance", (Object)new File(core.getResourceLoader().getInstanceDir()).getAbsolutePath());
        try {
            dirs.add("data", (Object)core.getDirectoryFactory().normalize(core.getDataDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized data directory path", (Throwable)e);
            dirs.add("data", (Object)"N/A");
        }
        dirs.add("dirimpl", (Object)core.getDirectoryFactory().getClass().getName());
        try {
            dirs.add("index", (Object)core.getDirectoryFactory().normalize(core.getIndexDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized index directory path", (Throwable)e);
            dirs.add("index", (Object)"N/A");
        }
        info.add("directory", (Object)dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", (Object)os.getName());
        info.add("version", (Object)os.getVersion());
        info.add("arch", (Object)os.getArch());
        info.add("systemLoadAverage", (Object)os.getSystemLoadAverage());
        SystemInfoHandler.addGetterIfAvaliable(os, "committedVirtualMemorySize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "freePhysicalMemorySize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "freeSwapSpaceSize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "processCpuTime", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalPhysicalMemorySize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalSwapSpaceSize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "openFileDescriptorCount", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "maxFileDescriptorCount", (NamedList<Object>)info);
        try {
            if (!os.getName().toLowerCase(Locale.ROOT).startsWith("windows")) {
                info.add("uname", (Object)SystemInfoHandler.execute("uname -a"));
                info.add("uptime", (Object)SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    static void addGetterIfAvaliable(Object obj, String getter, NamedList<Object> info) {
        try {
            String n = Character.toUpperCase(getter.charAt(0)) + getter.substring(1);
            Method m = obj.getClass().getMethod("get" + n, new Class[0]);
            m.setAccessible(true);
            Object v = m.invoke(obj, (Object[])null);
            if (v != null) {
                info.add(getter, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(String cmd) {
        DataInputStream in = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            in = new DataInputStream(process.getInputStream());
            String string = IOUtils.toString((Reader)new InputStreamReader((InputStream)in, Charset.defaultCharset()));
            return string;
        }
        catch (Exception ex) {
            String string = "(error executing: " + cmd + ")";
            return string;
        }
        finally {
            if (process != null) {
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
        }
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap jvm = new SimpleOrderedMap();
        String javaVersion = System.getProperty("java.specification.version", "unknown");
        String javaVendor = System.getProperty("java.specification.vendor", "unknown");
        String javaName = System.getProperty("java.specification.name", "unknown");
        String jreVersion = System.getProperty("java.version", "unknown");
        String jreVendor = System.getProperty("java.vendor", "unknown");
        String vmVersion = System.getProperty("java.vm.version", "unknown");
        String vmVendor = System.getProperty("java.vm.vendor", "unknown");
        String vmName = System.getProperty("java.vm.name", "unknown");
        jvm.add("version", (Object)(jreVersion + " " + vmVersion));
        jvm.add("name", (Object)(jreVendor + " " + vmName));
        SimpleOrderedMap java = new SimpleOrderedMap();
        java.add("vendor", (Object)javaVendor);
        java.add("name", (Object)javaName);
        java.add("version", (Object)javaVersion);
        jvm.add("spec", (Object)java);
        SimpleOrderedMap jre = new SimpleOrderedMap();
        jre.add("vendor", (Object)jreVendor);
        jre.add("version", (Object)jreVersion);
        jvm.add("jre", (Object)jre);
        SimpleOrderedMap vm = new SimpleOrderedMap();
        vm.add("vendor", (Object)vmVendor);
        vm.add("name", (Object)vmName);
        vm.add("version", (Object)vmVersion);
        jvm.add("vm", (Object)vm);
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", (Object)runtime.availableProcessors());
        DecimalFormat df = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        SimpleOrderedMap mem = new SimpleOrderedMap();
        SimpleOrderedMap raw = new SimpleOrderedMap();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        double percentUsed = (double)used / (double)max * 100.0;
        raw.add("free", (Object)free);
        mem.add("free", (Object)SystemInfoHandler.humanReadableUnits(free, df));
        raw.add("total", (Object)total);
        mem.add("total", (Object)SystemInfoHandler.humanReadableUnits(total, df));
        raw.add("max", (Object)max);
        mem.add("max", (Object)SystemInfoHandler.humanReadableUnits(max, df));
        raw.add("used", (Object)used);
        mem.add("used", (Object)(SystemInfoHandler.humanReadableUnits(used, df) + " (%" + df.format(percentUsed) + ")"));
        raw.add("used%", (Object)percentUsed);
        mem.add("raw", (Object)raw);
        jvm.add("memory", (Object)mem);
        SimpleOrderedMap jmx = new SimpleOrderedMap();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            jmx.add("bootclasspath", (Object)mx.getBootClassPath());
            jmx.add("classpath", (Object)mx.getClassPath());
            jmx.add("commandLineArgs", mx.getInputArguments());
            jmx.add("startTime", (Object)new Date(mx.getStartTime()));
            jmx.add("upTimeMS", (Object)mx.getUptime());
        }
        catch (Exception e) {
            log.warn("Error getting JMX properties", (Throwable)e);
        }
        jvm.add("jmx", (Object)jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        Package p = SolrCore.class.getPackage();
        info.add("solr-spec-version", (Object)p.getSpecificationVersion());
        info.add("solr-impl-version", (Object)p.getImplementationVersion());
        p = LucenePackage.class.getPackage();
        info.add("lucene-spec-version", (Object)p.getSpecificationVersion());
        info.add("lucene-impl-version", (Object)p.getImplementationVersion());
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_8/solr/core/src/java/org/apache/solr/handler/admin/SystemInfoHandler.java $";
    }

    private static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }
}

