/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.calais;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.uima.annotator.calais.DescriptionElement;
import org.apache.uima.annotator.calais.Offset;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFSaxHandler
extends DefaultHandler {
    DescriptionElement currentDesc = null;
    private boolean enableOffset = false;
    private boolean enableLength = false;
    private boolean enableDocument = false;
    private Offset offset;
    private HashMap<String, DescriptionElement> elements;
    private ArrayList<DescriptionElement> subjectMap;

    public RDFSaxHandler(HashMap<String, DescriptionElement> elements, ArrayList<DescriptionElement> subjectMap, Offset offset) {
        this.elements = elements;
        this.subjectMap = subjectMap;
        this.offset = offset;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("rdf:Description")) {
            this.elements.put(this.currentDesc.getAboutURL(), this.currentDesc);
            if (this.currentDesc.getSubjectURL() != null) {
                this.subjectMap.add(this.currentDesc);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rdf:Description")) {
            this.currentDesc = new DescriptionElement();
            this.currentDesc.setAboutURL(attributes.getValue("rdf:about"));
        } else if (qName.equals("rdf:type")) {
            this.currentDesc.setTypeURL(attributes.getValue("rdf:resource"));
        } else if (qName.equals("c:subject")) {
            this.currentDesc.setSubjectURL(attributes.getValue("rdf:resource"));
        } else if (qName.equals("c:offset")) {
            this.enableOffset = true;
        } else if (qName.equals("c:length")) {
            this.enableLength = true;
        } else if (qName.equals("rdf:RDF")) {
            this.enableDocument = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.enableOffset) {
            this.currentDesc.setOffset(Integer.parseInt(new String(ch, start, length)));
            this.enableOffset = false;
        } else if (this.enableLength) {
            this.currentDesc.setLength(Integer.parseInt(new String(ch, start, length)));
            this.enableLength = false;
        } else if (this.enableDocument) {
            String documentText = new String(ch, start, length);
            this.offset.setOffset(documentText.toLowerCase().indexOf("<body>") + 6);
            this.enableDocument = false;
        }
    }
}

