/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.util.Locale;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<T> {
    private Class<T> type_;

    public EnumArgumentType(Class<T> type) {
        this.type_ = type;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        try {
            return Enum.valueOf(this.type_, value);
        }
        catch (IllegalArgumentException e) {
            String choices = TextHelper.concat(this.type_.getEnumConstants(), 0, ",", "{", "}");
            throw new ArgumentParserException(String.format((Locale)null, "could not convert '%s' (choose from %s)", value, choices), (Throwable)e, parser, arg);
        }
    }
}

