/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.db.cbean.AccessResultCB;
import org.seasar.robot.db.cbean.UrlQueueCB;
import org.seasar.robot.db.exbhv.AccessResultBhv;
import org.seasar.robot.db.exbhv.UrlQueueBhv;
import org.seasar.robot.db.exentity.AccessResult;
import org.seasar.robot.dbflute.cbean.PagingResultBean;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.service.UrlQueueService;
import org.seasar.robot.util.LruHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUrlQueueServiceImpl
implements UrlQueueService {
    private static final String EMPTY_STRING = "";
    private static final Logger logger = LoggerFactory.getLogger(DBUrlQueueServiceImpl.class);
    protected static volatile Map<String, LinkedList<UrlQueue>> URL_QUEUE_MAP = new HashMap<String, LinkedList<UrlQueue>>();
    private static ConcurrentHashMap<String, LruHashMap<String, String>> VISITED_URL_CACHE_MAP = new ConcurrentHashMap();
    public int cacheSize = 1000;
    public int visitedUrlCacheSize = 1000;
    public int generatedUrlQueueSize = 1000;
    @Resource
    protected UrlQueueBhv urlQueueBhv;
    @Resource
    protected AccessResultBhv accessResultBhv;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<UrlQueue> getUrlQueueList(String sessionId) {
        LinkedList<Object> urlQueueList = URL_QUEUE_MAP.get(sessionId);
        if (urlQueueList == null) {
            Map<String, LinkedList<UrlQueue>> map = URL_QUEUE_MAP;
            synchronized (map) {
                urlQueueList = URL_QUEUE_MAP.get(sessionId);
                if (urlQueueList == null) {
                    urlQueueList = new LinkedList();
                    URL_QUEUE_MAP.put(sessionId, urlQueueList);
                }
            }
        }
        return urlQueueList;
    }

    public void updateSessionId(String oldSessionId, String newSessionId) {
        LinkedList<UrlQueue> urlQueueList = this.getUrlQueueList(oldSessionId);
        URL_QUEUE_MAP.put(newSessionId, urlQueueList);
        URL_QUEUE_MAP.remove(oldSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String sessionId, String url) {
        LinkedList<UrlQueue> urlQueueList;
        LinkedList<UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            org.seasar.robot.db.exentity.UrlQueue urlQueue = new org.seasar.robot.db.exentity.UrlQueue();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod("GET");
            urlQueue.setUrl(url);
            urlQueue.setDepth(Integer.valueOf(0));
            urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
            urlQueueList.add((UrlQueue)urlQueue);
        }
    }

    public void insert(UrlQueue urlQueue) {
        this.urlQueueBhv.insert((org.seasar.robot.db.exentity.UrlQueue)urlQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String sessionId) {
        int count = this.urlQueueBhv.deleteBySessionId(sessionId);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue: " + count);
        }
        Map<String, LinkedList<UrlQueue>> map = URL_QUEUE_MAP;
        synchronized (map) {
            URL_QUEUE_MAP.remove(sessionId);
            VISITED_URL_CACHE_MAP.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        int count = this.urlQueueBhv.deleteAll();
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue: " + count);
        }
        Map<String, LinkedList<UrlQueue>> map = URL_QUEUE_MAP;
        synchronized (map) {
            URL_QUEUE_MAP.clear();
            VISITED_URL_CACHE_MAP.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerAll(String sessionId, List<UrlQueue> newUrlQueueList) {
        LinkedList<UrlQueue> urlQueueList;
        LinkedList<UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            ArrayList<org.seasar.robot.db.exentity.UrlQueue> targetList = new ArrayList<org.seasar.robot.db.exentity.UrlQueue>();
            for (UrlQueue urlQueue : newUrlQueueList) {
                if (!this.isNewUrl(urlQueue, urlQueueList, true)) continue;
                targetList.add((org.seasar.robot.db.exentity.UrlQueue)urlQueue);
            }
            this.urlQueueBhv.batchInsert(targetList);
        }
    }

    private LruHashMap<String, String> getVisitedUrlCache(String sessionId) {
        LruHashMap<String, String> urlMap;
        LruHashMap<String, String> visitedUrlMap = VISITED_URL_CACHE_MAP.get(sessionId);
        if (visitedUrlMap == null && (urlMap = VISITED_URL_CACHE_MAP.putIfAbsent(sessionId, visitedUrlMap = new LruHashMap<String, String>(this.visitedUrlCacheSize))) != null) {
            visitedUrlMap = urlMap;
        }
        return visitedUrlMap;
    }

    protected boolean isNewUrl(UrlQueue urlQueue, List<UrlQueue> urlQueueList, boolean cache) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url);
            }
            return false;
        }
        if (cache) {
            String sessionId = urlQueue.getSessionId();
            if (this.getVisitedUrlCache(sessionId).containsKey((Object)url)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("URL exists in a cache: " + url);
                }
                return false;
            }
            this.getVisitedUrlCache(sessionId).put((Object)urlQueue.getUrl(), (Object)EMPTY_STRING);
        }
        for (UrlQueue urlInQueue : urlQueueList) {
            if (!url.equals(urlInQueue.getUrl())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue: " + url);
            }
            return false;
        }
        UrlQueueCB cb1 = new UrlQueueCB();
        cb1.query().setUrl_Equal(url);
        cb1.query().setSessionId_Equal(urlQueue.getSessionId());
        int count1 = this.urlQueueBhv.selectCount(cb1);
        if (count1 > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue db: " + url);
            }
            return false;
        }
        AccessResultCB cb2 = new AccessResultCB();
        cb2.query().setUrl_Equal(url);
        cb2.query().setSessionId_Equal(urlQueue.getSessionId());
        int count2 = this.accessResultBhv.selectCount(cb2);
        if (count2 > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a result: " + url);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlQueue poll(String sessionId) {
        LinkedList<UrlQueue> urlQueueList;
        LinkedList<UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            if (urlQueueList.isEmpty()) {
                UrlQueueCB cb = new UrlQueueCB();
                cb.paging(this.cacheSize, 1);
                cb.query().setSessionId_Equal(sessionId);
                PagingResultBean uqList = this.urlQueueBhv.selectPage(cb);
                if (!uqList.isEmpty()) {
                    urlQueueList.addAll((Collection<UrlQueue>)uqList);
                    ArrayList<Long> idList = new ArrayList<Long>(this.cacheSize);
                    for (UrlQueue uq : uqList) {
                        idList.add(uq.getId());
                    }
                    cb = new UrlQueueCB();
                    cb.query().setId_InScope(idList);
                    this.urlQueueBhv.queryDelete(cb);
                }
            }
            return urlQueueList.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(String sessionId) {
        LinkedList<UrlQueue> urlQueueList;
        LinkedList<UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            ArrayList<org.seasar.robot.db.exentity.UrlQueue> targetUrlQueueList = new ArrayList<org.seasar.robot.db.exentity.UrlQueue>();
            for (UrlQueue urlQueue : urlQueueList) {
                urlQueue.setId(null);
                targetUrlQueueList.add((org.seasar.robot.db.exentity.UrlQueue)urlQueue);
            }
            this.urlQueueBhv.batchInsert(targetUrlQueueList);
            urlQueueList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visited(UrlQueue urlQueue) {
        LinkedList<UrlQueue> urlQueueList;
        LinkedList<UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(urlQueue.getSessionId());
        synchronized (linkedList) {
            return !this.isNewUrl(urlQueue, urlQueueList, false);
        }
    }

    public void generateUrlQueues(String previousSessionId, String sessionId) {
        AccessResultCB cb = new AccessResultCB();
        cb.query().setSessionId_Equal(previousSessionId);
        cb.query().addOrderBy_CreateTime_Asc();
        int count = this.accessResultBhv.selectCount(cb);
        ArrayList<org.seasar.robot.db.exentity.UrlQueue> urlQueueList = new ArrayList<org.seasar.robot.db.exentity.UrlQueue>();
        int i = 0;
        while (i * this.generatedUrlQueueSize < count) {
            urlQueueList.clear();
            cb.paging(this.generatedUrlQueueSize, i + 1);
            PagingResultBean selectPage = this.accessResultBhv.selectPage(cb);
            for (AccessResult entity : selectPage) {
                org.seasar.robot.db.exentity.UrlQueue urlQueue = new org.seasar.robot.db.exentity.UrlQueue();
                urlQueue.setSessionId(sessionId);
                urlQueue.setMethod(entity.getMethod());
                urlQueue.setUrl(entity.getUrl());
                urlQueue.setParentUrl(entity.getParentUrl());
                urlQueue.setDepth(Integer.valueOf(0));
                urlQueue.setLastModified(entity.getLastModified());
                urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
                urlQueueList.add(urlQueue);
            }
            this.urlQueueBhv.batchInsert(urlQueueList);
            ++i;
        }
    }
}

