/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.seasar.robot.db.cbean.UrlFilterCB;
import org.seasar.robot.db.exbhv.UrlFilterBhv;
import org.seasar.robot.db.exentity.UrlFilter;
import org.seasar.robot.dbflute.cbean.ListResultBean;
import org.seasar.robot.service.UrlFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUrlFilterServiceImpl
implements UrlFilterService {
    private final Logger logger = LoggerFactory.getLogger(DBUrlFilterServiceImpl.class);
    private static final String INCLUDE_FILTER_TYPE = "I";
    private static final String EXCLUDE_FILTER_TYPE = "E";
    @Resource
    protected UrlFilterBhv urlFilterBhv;
    protected List<Pattern> includeUrlPatternListCache = null;
    protected List<Pattern> excludeUrlPatternListCache = null;
    protected int maxCacheSize = 10000;

    public void addIncludeUrlFilter(String sessionId, String url) {
        this.addUrlFilter(sessionId, url, INCLUDE_FILTER_TYPE);
    }

    public void addIncludeUrlFilter(String sessionId, List<String> urlList) {
        this.addUrlFilter(sessionId, urlList, INCLUDE_FILTER_TYPE);
    }

    public void addExcludeUrlFilter(String sessionId, String url) {
        this.addUrlFilter(sessionId, url, EXCLUDE_FILTER_TYPE);
    }

    public void addExcludeUrlFilter(String sessionId, List<String> urlList) {
        this.addUrlFilter(sessionId, urlList, EXCLUDE_FILTER_TYPE);
    }

    protected void addUrlFilter(String sessionId, String url, String filterType) {
        try {
            Pattern.compile(url);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Invalid url filter pattern: " + url);
            }
            return;
        }
        this.clearCache();
        UrlFilter urlFilter = new UrlFilter();
        urlFilter.setSessionId(sessionId);
        urlFilter.setUrl(url);
        urlFilter.setFilterType(filterType);
        urlFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.urlFilterBhv.insert(urlFilter);
    }

    protected void addUrlFilter(String sessionId, List<String> urlList, String filterType) {
        this.clearCache();
        ArrayList<UrlFilter> urlFilterList = new ArrayList<UrlFilter>();
        for (String url : urlList) {
            try {
                Pattern.compile(url);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Invalid url filter pattern: " + url);
                continue;
            }
            UrlFilter urlFilter = new UrlFilter();
            urlFilter.setSessionId(sessionId);
            urlFilter.setUrl(url);
            urlFilter.setFilterType(filterType);
            urlFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
            urlFilterList.add(urlFilter);
        }
        this.urlFilterBhv.batchInsert(urlFilterList);
    }

    public void delete(String sessionId) {
        this.clearCache();
        this.urlFilterBhv.deleteBySessionId(sessionId);
    }

    public void deleteAll() {
        this.clearCache();
        this.urlFilterBhv.deleteAll();
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        if (this.includeUrlPatternListCache == null) {
            List<Pattern> urlPatternList = this.getUrlPatternList(sessionId, INCLUDE_FILTER_TYPE);
            if (urlPatternList.size() < this.maxCacheSize) {
                this.includeUrlPatternListCache = urlPatternList;
            }
            return urlPatternList;
        }
        return this.includeUrlPatternListCache;
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        if (this.excludeUrlPatternListCache == null) {
            List<Pattern> urlPatternList = this.getUrlPatternList(sessionId, EXCLUDE_FILTER_TYPE);
            if (urlPatternList.size() < this.maxCacheSize) {
                this.excludeUrlPatternListCache = urlPatternList;
            }
            return urlPatternList;
        }
        return this.excludeUrlPatternListCache;
    }

    protected List<Pattern> getUrlPatternList(String sessionId, String filterType) {
        UrlFilterCB cb = new UrlFilterCB();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().setFilterType_Equal(filterType);
        ListResultBean urlFilterList = this.urlFilterBhv.selectList(cb);
        ArrayList<Pattern> urlPatternList = new ArrayList<Pattern>();
        for (UrlFilter urlFilter : urlFilterList) {
            urlPatternList.add(Pattern.compile(urlFilter.getUrl()));
        }
        return urlPatternList;
    }

    protected void clearCache() {
        this.includeUrlPatternListCache = null;
        this.excludeUrlPatternListCache = null;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }
}

