/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.io.RandomAccess;

public class RandomAccessBuffer
implements RandomAccess {
    private static final int BUFFER_SIZE = 16384;
    private ArrayList<byte[]> bufferList = new ArrayList();
    private byte[] currentBuffer = new byte[16384];
    private long pointer;
    private long currentBufferPointer;
    private long size;
    private int bufferListIndex;
    private int bufferListMaxIndex;

    public RandomAccessBuffer() {
        this.bufferList.add(this.currentBuffer);
        this.pointer = 0L;
        this.currentBufferPointer = 0L;
        this.size = 0L;
        this.bufferListIndex = 0;
        this.bufferListMaxIndex = 0;
    }

    public RandomAccessBuffer clone() {
        RandomAccessBuffer copy = new RandomAccessBuffer();
        copy.bufferList = new ArrayList(this.bufferList.size());
        for (byte[] buffer : this.bufferList) {
            byte[] newBuffer = new byte[buffer.length];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            copy.bufferList.add(newBuffer);
        }
        copy.currentBuffer = (byte[])(this.currentBuffer != null ? copy.bufferList.get(copy.bufferList.size() - 1) : null);
        copy.pointer = this.pointer;
        copy.currentBufferPointer = this.currentBufferPointer;
        copy.size = this.size;
        copy.bufferListIndex = this.bufferListIndex;
        copy.bufferListMaxIndex = this.bufferListMaxIndex;
        return copy;
    }

    public void close() throws IOException {
        this.currentBuffer = null;
        this.bufferList.clear();
        this.pointer = 0L;
        this.currentBufferPointer = 0L;
        this.size = 0L;
        this.bufferListIndex = 0;
    }

    public void seek(long position) throws IOException {
        this.checkClosed();
        this.pointer = position;
        this.bufferListIndex = (int)(position / 16384L);
        this.currentBufferPointer = position % 16384L;
        this.currentBuffer = this.bufferList.get(this.bufferListIndex);
    }

    public long getPosition() throws IOException {
        this.checkClosed();
        return this.pointer;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.pointer >= this.size) {
            return -1;
        }
        if (this.currentBufferPointer >= 16384L) {
            if (this.bufferListIndex >= this.bufferListMaxIndex) {
                return -1;
            }
            this.currentBuffer = this.bufferList.get(++this.bufferListIndex);
            this.currentBufferPointer = 0L;
        }
        ++this.pointer;
        return this.currentBuffer[(int)this.currentBufferPointer++] & 0xFF;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        long remainingBytes;
        this.checkClosed();
        if (this.pointer >= this.size) {
            return 0;
        }
        int maxLength = (int)Math.min((long)length, this.size - this.pointer);
        if ((long)maxLength >= (remainingBytes = 16384L - this.currentBufferPointer)) {
            System.arraycopy(this.currentBuffer, (int)this.currentBufferPointer, b, offset, (int)remainingBytes);
            int newOffset = offset + (int)remainingBytes;
            long remainingBytes2Read = (long)length - remainingBytes;
            int numberOfArrays = (int)remainingBytes2Read / 16384;
            for (int i = 0; i < numberOfArrays; ++i) {
                this.nextBuffer();
                System.arraycopy(this.currentBuffer, 0, b, newOffset, 16384);
                newOffset += 16384;
            }
            if ((remainingBytes2Read %= 16384L) > 0L) {
                this.nextBuffer();
                System.arraycopy(this.currentBuffer, 0, b, newOffset, (int)remainingBytes2Read);
                this.currentBufferPointer += remainingBytes2Read;
            }
        } else {
            System.arraycopy(this.currentBuffer, (int)this.currentBufferPointer, b, offset, maxLength);
            this.currentBufferPointer += (long)maxLength;
        }
        this.pointer += (long)maxLength;
        return maxLength;
    }

    public long length() throws IOException {
        this.checkClosed();
        return this.size;
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.currentBufferPointer >= 16384L) {
            if (this.pointer + 16384L >= Integer.MAX_VALUE) {
                throw new IOException("RandomAccessBuffer overflow");
            }
            this.expandBuffer();
        }
        this.currentBuffer[(int)this.currentBufferPointer++] = (byte)b;
        ++this.pointer;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
        if (this.currentBufferPointer >= 16384L) {
            if (this.pointer + 16384L >= Integer.MAX_VALUE) {
                throw new IOException("RandomAccessBuffer overflow");
            }
            this.expandBuffer();
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        long newSize = this.pointer + (long)length;
        long remainingBytes = 16384L - this.currentBufferPointer;
        if ((long)length >= remainingBytes) {
            if (newSize > Integer.MAX_VALUE) {
                throw new IOException("RandomAccessBuffer overflow");
            }
            System.arraycopy(b, offset, this.currentBuffer, (int)this.currentBufferPointer, (int)remainingBytes);
            int newOffset = offset + (int)remainingBytes;
            long remainingBytes2Write = (long)length - remainingBytes;
            int numberOfNewArrays = (int)remainingBytes2Write / 16384;
            for (int i = 0; i < numberOfNewArrays; ++i) {
                this.expandBuffer();
                System.arraycopy(b, newOffset, this.currentBuffer, (int)this.currentBufferPointer, 16384);
                newOffset += 16384;
            }
            if ((remainingBytes2Write -= (long)(numberOfNewArrays * 16384)) >= 0L) {
                this.expandBuffer();
                if (remainingBytes2Write > 0L) {
                    System.arraycopy(b, newOffset, this.currentBuffer, (int)this.currentBufferPointer, (int)remainingBytes2Write);
                }
                this.currentBufferPointer = remainingBytes2Write;
            }
        } else {
            System.arraycopy(b, offset, this.currentBuffer, (int)this.currentBufferPointer, length);
            this.currentBufferPointer += (long)length;
        }
        this.pointer += (long)length;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }

    private void expandBuffer() {
        if (this.bufferListMaxIndex > this.bufferListIndex) {
            this.nextBuffer();
        } else {
            this.currentBuffer = new byte[16384];
            this.bufferList.add(this.currentBuffer);
            this.currentBufferPointer = 0L;
            ++this.bufferListMaxIndex;
            ++this.bufferListIndex;
        }
    }

    private void nextBuffer() {
        this.currentBufferPointer = 0L;
        this.currentBuffer = this.bufferList.get(++this.bufferListIndex);
    }

    private void checkClosed() throws IOException {
        if (this.currentBuffer == null) {
            throw new IOException("RandomAccessBuffer already closed");
        }
    }
}

